const BaseClient = require("./baseClient")
const settings = require("../../../config/settings");
const system = require("../../system");
const { appKey, secret } = settings;
/**
 * 工商 产品
 */
class GongshangClient extends BaseClient {
    constructor() {
        super(appKey, secret, "/web/action/regapi/springBoard");
        this.instance = null;
        this.productType = [
            {
                zzbType: system.SERVICECODE.COMPANYCASE,
                qftType: "GSZZ"
            }, {
                zzbType: system.SERVICECODE.OPENBANKACCOUNTCASE,
                qftType: "YHKH"
            }, {
                zzbType: system.SERVICECODE.TAXCASE,
                qftType: "SWBD"
            }, {
                zzbType: system.SERVICECODE.REGADDRCASE1,
                qftType: "DZFW"
            }, {
                zzbType: system.SERVICECODE.AGENTCASE1,
                qftType: "DLJZ"
            },
        ];
        this.CIRCUITSTATUS = {
            RECEIVED: 701,//已接单
            COLLECTING: 702,//材料收集环节
            AUDITING: 703,//工商审核环节
            ENGRAVING: 704,//刻章环节
            SUCCESS: 705,//已完成
            SERVICEING: 706//服务中
        }
    }

    static getInstance() {
        if (!this.instance) {
            this.instance = new GongshangClient();
        }
        return this.instance;
    }

    async submitMaterials(username, deliverData, materials) {
        const { companyInfo, materialFile, } = materials;
        let { applicationFormUrl, registDocumentsUrl } = materialFile;
        let { companyName, spareName, companyProperties, fullAddress, engagedIndustry,
            businessScope, operatingPeriod, addressType, taxpayerType, serviceArea } = companyInfo;
        // if (serviceArea.length == 2) {
        //     if (serviceArea[1] === "市辖区") {
        //         serviceArea = serviceArea[0];
        //     } else {
        //         serviceArea = serviceArea[1];
        //     }
        // } else {
        //     serviceArea = undefined;
        // }
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.COLLECTING: // 工商审核环节
                status = this.CIRCUITSTATUS.AUDITING;
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = this.CIRCUITSTATUS.AUDITING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = this.CIRCUITSTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.SUCCESS:
                return "SUCCESS"
            default:
                throw new Error("此状态手动不能更改");
        }
        let pushData = {
            orderNo: deliverData.delivery_code,
            consultType: deliverData.delivery_info.bizType || "GSREG",
            status,
            deliverContent: {
                applicationFormUrl: applicationFormUrl.url,
                registDocumentsUrl: registDocumentsUrl.url,
                baseInfo: {},
                companyInfo: {
                    companyName,
                    spareName: spareName.filter(item => {
                        return item;
                    }),
                    companyProperties,
                    addressType,
                    fullAddress,
                    taxpayerType,
                    serviceArea,
                    engagedIndustry,
                    businessScope,
                    operatingPeriod
                }
            },
        }
        if (deliverData.is_package) {
            pushData.productType = this.productType.find((item) => {
                return item.zzbType === deliverData.product_code
            }).qftType;
        }
        await this.pushQiFuTong(username, {
            actionType: "regUpdateOrderStatus",
            actionBody: pushData
        });
    }

    async changeStatus(username, deliverData, materials = {}) {
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.RECEIVED:
                switch (deliverData.product_code) {
                    case system.SERVICECODE.COMPANYCASE:
                    case system.SERVICECODE.REGADDRCASE1:
                        status = this.CIRCUITSTATUS.COLLECTING;
                        break
                    case system.SERVICECODE.TAXCASE:
                    case system.SERVICECODE.OPENBANKACCOUNTCASE:
                        status = this.CIRCUITSTATUS.SUCCESS;
                        break
                    case system.SERVICECODE.AGENTCASE1:
                        status = this.CIRCUITSTATUS.SERVICEING;
                        break
                    default:
                        throw new Error("异常操作");
                }
                break
            case system.SERVERSESTATUS.COLLECTING: //  收集材料
                status = this.CIRCUITSTATUS.SERVICEING;
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = this.CIRCUITSTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = this.CIRCUITSTATUS.SUCCESS;
                break
            case system.SERVERSESTATUS.SERVICEING: // 服务中
                status = this.CIRCUITSTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }
        let pushData = {
            orderNo: deliverData.delivery_code,
            status,
            consultType: deliverData.delivery_info.bizType || "GSREG",
        }
        // 套餐 判断
        if (deliverData.is_package) {
            pushData.productType = this.productType.find((item) => {
                return item.zzbType === deliverData.product_code
            }).qftType;
        }

        // 代理记账、地址服务 的截止时间
        if (
            (system.SERVICECODE.REGADDRCASE1 === deliverData.product_code &&
                deliverData.delivery_status === system.SERVERSESTATUS.SERVICEING) ||
            (system.SERVICECODE.AGENTCASE1 === deliverData.product_code &&
                deliverData.delivery_status === system.SERVERSESTATUS.RECEIVED)
        ) {
            pushData.startTime = new Date(deliverData.delivery_info.startTime).getTime() / 1000;
            pushData.endTime = new Date(deliverData.delivery_info.endTime).getTime() / 1000;
        }

        // 材料信息 
        if (Object.keys(materials).length) {
            pushData = {
                ...pushData,
                ...materials
            }
        }


        await this.pushQiFuTong(username, {
            actionType: "regUpdateOrderStatus",
            actionBody: pushData
        });
    }
}

module.exports = GongshangClient