var system = require("../../../system");
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const appconfig = system.getSysConfig();
class FitaxcompanyCtl extends CtlBase {
    constructor() {
        super("bizchance", CtlBase.getServiceName(FitaxcompanyCtl));
    }

    /**
     * 根据需求编号查询企业信息
     * @param {*} mobj
    */
    async findOne(mobj, qobj, req) {
        let pobj = mobj.d;
        try {
            if (!pobj.demand_code) {
                return system.getResultError("fitaxschemeCtl/findOne 缺少需求编号!");
            }
            let res = await this.service.findInfo(pobj);
            return system.getResult(res);
        } catch (error) {
            console.log("fitaxschemeCtl/findOne " + error);
            return system.getResultError("fitaxschemeCtl/findOne 查询企业失败!");
        }
    }

    /**
       * 新建&更新企业信息
       * @param {*} mobj
      */
    async insertOrUpdateInfo(mobj, qobj, req) {
        let pobj = mobj.d;
        try {
            if (!pobj.demand_code) {
                return system.getResultError("fitaxschemeCtl/insertInfo 缺少需求编号!");
            }
            let findRes = await this.service.findInfo(pobj);
            if (!findRes) {
                let insertRes = await this.service.insertInfo(pobj);
                return system.getResult("添加企业成功!");
            }
            let updateRes = await this.service.updateInfo(pobj);
            return system.getResult("修改企业信息成功!");
        } catch (error) {
            console.log("fitaxschemeCtl/insertOrUpdateInfo " + error);
            return system.getResultError("fitaxschemeCtl/insertOrUpdateInfo 添加&修改企业信息失败!");
        }
    }
}
module.exports = FitaxcompanyCtl;

