var system = require("../../../system");
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const { json, JSON } = require("sequelize");
const appconfig = system.getSysConfig();
class FitaxpushqueueCtl extends CtlBase {
    constructor() {
        super("bizchance", CtlBase.getServiceName(FitaxpushqueueCtl));
        this.rysUrl = settings.rysUrl();
    }
    /**
     * 新建信息
     * @param {*} mobj
    */
    async insertInfo(pobj, qobj, req) {
        try {
            if (!pobj.delivery_code || !pobj.current_period) {
                return system.getResultError("FitaxpushqueueCtl/insertInfo 缺少必要参数!");
            }
            let res = await this.service.insertInfo(pobj);
            return system.getResult(res);
        } catch (error) {
            console.log("FitaxpushqueueCtl/insertInfo---------------------------------------------------------------- " + error);
            return system.getResultError("FitaxpushqueueCtl/insertInfo 新建方案出错!");
        }
    }

    /**
     * @param {*} pobj
     * @param {*} qobj
     * @param {*} req
    */
    async updateInfo(pobj, qobj, req) {
        let obj = {};
        if (pobj.actionBody.bizNo) {
            obj.demand_code = pobj.actionBody.bizNo;
        }
        if (pobj.actionBody.accountDate) {
            obj.current_period = pobj.actionBody.pobj.actionBody.accountDate;
        }
        if (pobj.actionBody.dataType){
            obj.data_type = pobj.actionBody.dataType;
        }
        if (pobj.actionBody.reqData){
            obj.req_data = pobj.actionBody.reqData;
        }
        if (pobj.actionBody.resData){
            obj.res_data = pobj.actionBody.resData;
        }
        if (pobj.actionBody.rysCheck){
            obj.rys_check = pobj.actionBody.rysCheck;
        }
        if (pobj.actionBody.pushStatus){
            obj.push_status = pobj.actionBody.pushStatus;
        }
        if (pobj.actionBody.checkDate){
            obj.check_date = pobj.actionBody.checkDate;
        }
        try {
            let res = await this.service.updateInfo(obj);
            return system.getResult(res);
        } catch (error) {
            console.log("fitaxschemeCtl/updateInfo error: " + error);
            return system.getResultError("updateInfo error: " + error)
        }
    }
}
module.exports = FitaxpushqueueCtl;

