var system = require("../../../system");
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const appconfig = system.getSysConfig();
class SettleBillCtl extends CtlBase {
  constructor() {
    super("bizchance", CtlBase.getServiceName(SettleBillCtl));
  }
  async advice(p,q,req){
    let sid= p.advice.settleId
    let msg=p.advice.memo
    let userid=p.userid
    let userName=p.username
    let rtn=await this.service.advice(sid,msg,userid,userName)
    return system.getResult(rtn)
  }
  async  auditPass(p,q,req){
    let sid= p.pass.settleId
    let rtn=await this.service.auditPass(sid,p.userid,p.username)
    return system.getResult(rtn)
  }
  async  pay(p,q,req){
    let sid= p.pay.settleId
    let rtn=await this.service.pay(sid,p.userid,p.username)
    return system.getResult(rtn)
  }
}
module.exports = SettleBillCtl;

