const system = require("../../../system");
const Dao = require("../../dao.base");
class OperationrecordDao extends Dao {
  constructor() {
    super(Dao.getModelName(OperationrecordDao));
  }

  /**
  *查询
  *@param {*} qobj
 */
  async findAllInfo(qobj) {
    qobj.order_type = "BIZ";//数据类型需求|订单
    return await this.model.findAll({ where: qobj, order: [["created_at","DESC"]] });
  }

  /**
   * 插入状态信息
   * @param {*} qobj 
   * @param {*} t 
   */
  async insertInfo(qobj, t) {
    let obj = {
      "demand_code": qobj.demand_code,// 需求编码
      "order_type": "BIZ",
    }
    if (qobj.operator) {// 操作人
      obj.operator = qobj.operator;
    }
    if (qobj.operation_type) {// 操作类型
      obj.operation_type = qobj.operation_type;
    }
    if (qobj.operation_details) {// 操作详细记录json
      obj.operation_details = qobj.operation_details;
    }
    return await this.create(obj, t);
  }
}
module.exports = OperationrecordDao;

// let test = new OperationrecordDao();
// let a = {
//   "demand_code": "111"
// }

// start(a);
// async function start(a) {
//   let res = await test.findAllInfo(a);
//   console.log("结果:" + JSON.stringify(res));
// }