const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
/**
 * 交付单表
 */
module.exports = (db, DataTypes) => {
  return db.define("settlebill", {
    code: { //交付单编号
      allowNull: true,
      type: DataTypes.STRING
    },
    auditedStatus: {// 审核状态
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    settle_amount: {//结算金额
      allowNull: true,
      type: DataTypes.INTEGER
    },
    isPayedStatus:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    memo:{//结算建议
      allowNull: true,
      type:DataTypes.STRING,
    },
    creator_id:{//申请人
      allowNull: true,
      type: DataTypes.INTEGER
    },
    creator:{
      allowNull: true,
      type: DataTypes.STRING,
    },
    auditor_id:{//审核人
      allowNull: true,
      type: DataTypes.INTEGER
    },
    auditor:{//审核人
      allowNull: true,
      type: DataTypes.STRING,
    },
    payer_id:{//付款人
      allowNull: true,
      type: DataTypes.INTEGER
    },
    payer:{
      allowNull: true,
      type: DataTypes.STRING,
    },
    facilitator_id:{
      allowNull: true,
      type: DataTypes.INTEGER,
    },
    facilitator_name:{
      allowNull: true,
      type: DataTypes.STRING,
    },
  }, {
    paranoid: true,//真的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'fi_settlebill',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}

