const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require('../../../../config/settings')
class DeliverybillService extends ServiceBase {
  constructor() {
    super("rejreex", ServiceBase.getDaoName(DeliverybillService))
    this.restClient = system.getObject("util.restClient")
    this.tmDao = system.getObject("db.rejreex.trademarkcaseDao")
    this.tkurl = settings.qftkurl()
    this.qfurl = settings.qifuurl()
  }

  async createDeliver (params) {
    let tmData = params.delivery_info
    return await this.db.transaction(async t => {
      // 交付单表
      let res = await this.dao.insertInfo(params)
      // 商标关联表
      tmData.deliverId = res.id
      tmData.deliveryCode = params.delivery_code
      await this.tmDao.create(tmData)
      // 状态日志?
    })
  }

  async updateStatusByDeliverCode (qobj) {//* 根据交付单编号更新交付单状态 */
    var self = this;
    return self.db.transaction(async function (t) {
      return await self.dao.updateStatusByDeliverCode(qobj, t);
    });
  }

  /*更新业务员信息*/
  async updateSalesmanInfoByDeliverCode (qobj) {
    var self = this;
    return self.db.transaction(async function (t) {
      return await self.dao.updateSalesmanInfoByDeliverCode(qobj, t);
    });
  }

  async updateInfoByDeliverCode (qobj) {//*更新交付单信息 */
    console.log("--------------------------------------------------------------------------------------------------------------------------------------");
    var self = this;
    return self.db.transaction(async function (t) {
      let res = await this.dao.findOne({ delivery_code: qobj.deliverNumber })
      await self.tmDao.update(qobj.tmData, { deliverId: res.id })
      return await self.dao.updateInfoByDeliverCode(qobj, t);
    });
  }

  async getList (pobj) {
    console.log(pobj)
    let parentWhere = {}
    let childWhere = pobj.search
    if (pobj.opath && pobj.opath != "") {
      if(pobj.opath == '???') {
        parentWhere.salesman_id = pobj.userid
      }
    }

    switch (pobj.bizpath) {
      case '/dealaskfor/examine':
        childWhere.tradeStatus = '待审核'
        break
      case '/dealaskfor/refer':
        childWhere.tradeStatus = '申请递交中'
        break
      case '/myaskfor/pendingservice':
        childWhere.tradeStatus = '待完善材料'
        break
      case '/rejaskmanage/officalManager':
        childWhere.offical = { [this.db.Op.ne]: null }
        break
    }

    let query = {
      where: parentWhere,
      include: [{
        model: this.tmDao.model,
        where: childWhere
      }],
      order: [[this.tmDao.model, 'v_noticeDate', 'DESC']],
      offset: (pobj.pageInfo.pageNo - 1) * pobj.pageInfo.pageSize,
      limit: pobj.pageInfo.pageSize,
    }

    let result = await this.dao.model.findAndCountAll(query)
    return result
  }


}
module.exports = DeliverybillService;
