const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class RejcbService extends ServiceBase {
  constructor() {
    super()
    this.tcDao = system.getObject('db.rejreex.trademarkcaseDao')
    this.bcDao = system.getObject('db.common.bcdataDao')
    this.isTest = true
  }

  async getRejData () {
    let queryData
    if (this.isTest) {
      queryData = await this.tcDao.model.findAll({
        where: {
          caseId: { [this.db.Op.like]: `%TESTCB%` },
          tradeStatus: "商标局处理中",
          caStatus: "待提报"
        }
      })
    } else {
      queryData = await this.tcDao.model.findAll({
        where: {
          tradeStatus: "商标局处理中",
          caStatus: "待提报"
        }
      })
    }
    let data = this.dealData(queryData)
    return data;
  }

  // 组织驳回复审提报数据
  dealData (data) {
    let res = {}
    res.count = data.length
    res.data = []
    for (let i = 0; i < data.length; ++i) {
      let datatmp = {
        mobile: "13693797152",
        flowType: "驳回商标注册申请复审申请",
        regNum: data[i].askforId.trim() || "",
        appNum0:"true",      
      }
      datatmp.fileWtName = ""
      datatmp.fileWtUrl = data[i].applicant.entrust || ""
      if (datatmp.fileWtUrl) {
        let tarr = datatmp.fileWtUrl.split('/')
        datatmp.fileWtName = tarr[tarr.length - 1]
      }
      datatmp.dljcName = ""
      datatmp.dljcUrl = data[i].askForData.rmLicense || ""
      if (datatmp.dljcUrl) {
        let tarr = datatmp.dljcUrl.split('/')
        datatmp.dljcName = tarr[tarr.length - 1]
      }
    }
    return res
  }

  // 修改提报状态
  async changeStatus (data) {
    let param = {
      caStatus: data.status
    }
    if (!this.isTest) {
      param.tradeStatus = "待完善材料"
    }
    return await this.tcDao.model.update(param, { where: { askforId: data.regNum } })
  }

  // 保存商标局提交数据
  async saveBcData(data) {
    let param = {
      data:JSON.stringify(data),
      type: "变更代理人"
    }
   await this.bcDao.create(param)
  }

  // 初始化状态
  async initStatus () {
    return await this.tcDao.model.update({ caStatus: "待提报" }, { where: { caseId: { [this.db.Op.like]: `%TESTCB%` } } })
  }
}
module.exports = RejcbService;
