const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class RejcbService extends ServiceBase {
  constructor() {
    super()
    this.tcDao = system.getObject('db.rejreex.trademarkcaseDao')
    this.bcDao = system.getObject('db.common.bcdataDao')
    this.isTest = true
  }

  async getRejData () {
    let queryData
    if (this.isTest) {
      queryData = await this.tcDao.model.findAll({
        where: {
          caseId: { [this.db.Op.like]: `%TESTCB%` },
          tradeStatus: "商标局处理中",
          rejStatus: "待提报",
          caStatus: { [this.db.Op.in]: ["无变更"] }
        }
      })
    } else {
      queryData = await this.tcDao.model.findAll({
        where: {
          tradeStatus: "商标局处理中",
          rejStatus: "待提报",
          caStatus: { [this.db.Op.notIn]: ["待提报", "提报中"] }
        }
      })
    }
    let data = this.dealData(queryData)
    return data;
  }

  // 组织驳回复审提报数据
  dealData (data) {
    let res = {}
    res.count = data.length
    res.data = []
    for (let i = 0; i < data.length; ++i) {
      let datatmp = {}
      datatmp.mobile = "13693797152"

      let step1 = {}
      step1.regNum = data[i].askforId ? data[i].askforId.trim() : ""
      step1.intClsId = [`${parseInt(data[i].tradeType)}`] || ""
      step1.ifSplit = data[i].askForData.division == 1 ? "ifSplit1" : "ifSplit2"
      if (data[i].askForData.division) {
        step1.ifSplit1 = {}
        step1.ifSplit1.fgsqUrl = data[i].askForData.divisionDir || ""
        step1.ifSplit1.fgsqName = ""
        if (step1.ifSplit1.fgsqUrl) {
          let tmpifsplitArr = step1.ifSplit1.fgsqUrl.split('/')
          step1.ifSplit1.fgsqName = tmpifsplitArr[tmpifsplitArr.length - 1]
        }
      }
      datatmp.step1 = step1

      let step2 = {}
      step2.appGjdq = data[i].applicant.country ? data[i].applicant.country.trim() : ""
      step2.dlsqrLx = data[i].applicant.applicantType ? data[i].applicant.applicantType.trim() : ""
      step2.certCode = data[i].usccode ? data[i].usccode.trim() : ""
      switch (data[i].caseId) {
        case 'TESTCBSELECT01':
          step2.isChangeName = "select1"
          step2.select1 = {
            appBgName: "测试",
            fileBgName: "zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf",
            fileBgUrl: "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf",
            fileYyZzName: "zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf",
            fileYyZzUrl: "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf"
          }
          break
        case 'TESTCBSELECT02':
          step2.isChangeName = "select2"
          step2.select2 = {
            gtName: "测试",
            fileGtName: "zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf",
            fileGtUrl: "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf"
          }
          break
        case 'TESTCBSELECT03':
          step2.isChangeName = "select3"
          step2.select3 = {
            fsSqName: "测试",
            fileFsSqName: "zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf",
            fileFsSqUrl: "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_259615954136568492020221827368492韵达—公司宝业务授权.pdf"
          }
          break
        default:
          step2.isChangeName = ""
          break
      }

      step2.appCnAddr = data[i].applicant.addr ? data[i].applicant.addr.trim() : ""
      step2.appContactZip = data[i].applicant.mailCode ? data[i].applicant.mailCode.trim() : ""
      step2.appContactPerson = data[i].applicant.contactsName ? data[i].applicant.contactsName.trim() : ""
      step2.appContactTel = data[i].applicant.tel ? data[i].applicant.tel.trim() : ""
      step2.agentContactPerson = '张飞龙'
      step2.agentPerson = '张飞龙'
      step2.agentContactTel = '01084927588'
      step2.fileWtName = ""
      step2.fileWtUrl = data[i].applicant.entrust || ""
      if (step2.fileWtUrl) {
        let tmpwtArr = step2.fileWtUrl.split('/')
        step2.fileWtName = tmpwtArr[tmpwtArr.length - 1]
      }
      step2.isSupplement = data[i].askForData.isNeedSup == 1 ? "isSupplement1" : "isSupplement2"
      datatmp.step2 = step2

      let step3 = {}
      step3.factandreason = data[i].askForData.far
      step3.factandreasonPdfName = ""
      step3.factandreasonPdfUrl = data[i].askForData.farDir || ""
      if (step3.factandreasonPdfUrl) {
        let tmpfarArr = step3.factandreasonPdfUrl.split('/')
        step3.factandreasonPdfName = tmpfarArr[tmpfarArr.length - 1]
      }
      step3.evidenceCatalogName = ""
      step3.evidenceCatalogUrl = data[i].askForData.evidenceDir || ""
      if (step3.evidenceCatalogUrl) {
        let tmpeviDirArr = step3.evidenceCatalogUrl.split('/')
        step3.evidenceCatalogName = tmpeviDirArr[tmpeviDirArr.length - 1]
      }
      step3.evidenceName = ""
      step3.evidenceUrl = data[i].askForData.evidenceCon || ""
      if (step3.evidenceUrl) {
        let tmpeviArr = step3.evidenceUrl.split('/')
        step3.evidenceName = tmpeviArr[tmpeviArr.length - 1]
      }
      step3.evidenceOfserviceName = ""
      step3.evidenceOfserviceUrl = data[i].askForData.evidenceSend || ""
      if (step3.evidenceOfserviceUrl) {
        let tmpesArr = step3.evidenceOfserviceUrl.split('/')
        step3.evidenceOfserviceName = tmpesArr[tmpesArr.length - 1]
      }
      step3.fileYgName = ""
      step3.fileYgUrl = data[i].askForData.explain || ""
      if (step3.fileYgUrl) {
        let tmpygArr = step3.fileYgUrl.split('/')
        step3.fileYgName = tmpygArr[tmpygArr.length - 1]
      }
      datatmp.step3 = step3

      res.data.push(datatmp)
    }
    return res
  }

  // 修改提报状态
  async changeStatus (data) {
    let param = {
      rejStatus: data.status
    }
    if (!this.isTest) {
      param.tradeStatus = "待完善材料"
    }
    return await this.tcDao.model.update(param, { where: { askforId: data.regNum } })
  }

  // 保存商标局提交数据
  async saveBcData(data) {
    let param = {
      data:JSON.stringify(data),
      type: "驳回复审"
    }
   await this.bcDao.create(param)
  }

  // 初始化状态
  async initStatus () {
    return await this.tcDao.model.update({ rejStatus: "待提报" }, { where: { caseId: { [this.db.Op.like]: `%TESTCB%` } } })
  }
}
module.exports = RejcbService;
