var childproc = require('child_process');
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const querystring = require('querystring');
var settings = require("../../config/settings");
const axios = require('axios')
class RestClient {
  constructor() {
    this.cmdGetPattern = "curl {-G} -k  -d '{data}' {url}";
    this.cmdPostPattern = "curl -k -H 'Content-type: application/json' -d '{data}' {url}";
    this.cmdDownLoadFilePattern = "curl -G -o {fileName} {url}";
    this.cmdPostPattern2 = "curl -k -H 'Content-type: application/x-www-form-urlencoded'  -d '{data}' {url}";
    this.cmdPostPatternWithAK = "curl -k -H 'Content-type: application/json'  -H  'AccessKey:{ak}'   -d '{data}' {url}";
    this.cmdPostPatternWithToken = "curl -k -H 'Content-type: application/json'  -H  'token:{token}'   -d '{data}' {url}";
    //云帐户
    // this.cmdPostPattern3="curl -k -H 'Content-type: application/x-www-form-urlencoded' -H 'dealer-id:"+settings.apiconfig.yunzhanghuDealer_id()+"' -H 'request-id:"+parseInt(Date.now() / 1000)+"_gsb"+"'  -d '{data}' {url}";
    // this.cmdGetPattern3 = "curl {-G} -k {url} --header 'dealer-id:"+settings.apiconfig.yunzhanghuDealer_id()+"'";
    //e签宝
    //this.cmdPostPattern4="curl -k -H 'Content-type: application/json' -H 'X-Tsign-Open-App-Id:"+settings.apiconfig.eSignBaoAppId()+"' -H 'X-Tsign-Open-App-Secret:"+settings.apiconfig.eSignBaoAppKey()+"' -d '{data}' {url}";

    // form-data形式post  data参数类型 md5=2&data=1
    this.cmdPostPattern5 = "curl -k --data '{data}' {url}";

  }
  FetchGetCmd (subData, url) {
    var cmd = this.cmdGetPattern.replace(/\{\-G\}/g, "-G").replace(
      /\{data\}/g, subData).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd (subData, url) {
    var data = JSON.stringify(subData);
    var cmd = this.cmdPostPattern.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmdWithAK (subData, url, acck) {
    var data = JSON.stringify(subData);
    var cmd = this.cmdPostPatternWithAK.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url).replace(/\{ak\}/g, acck);
    return cmd;
  }
  FetchPostCmdWithToken (subData, url, acck) {
    var data = JSON.stringify(subData);
    var cmd = this.cmdPostPatternWithToken.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url).replace(/\{token\}/g, acck);
    return cmd;
  }


  FetchPostCmd2 (subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern2.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd3 (subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern3.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchGetCmd3 (url) {
    var cmd = this.cmdGetPattern3.replace(/\{\-G\}/g, "-G").replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd4 (subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern4.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchPostCmd5 (subData, url) {
    var data = subData;
    var cmd = this.cmdPostPattern5.replace(/\{data\}/g,
      data).replace(/\{url\}/g, url);
    return cmd;
  }
  FetchDownLoadCmd (outfname, url) {
    // console.log(this.cmdPattern);
    var cmd = this.cmdDownLoadFilePattern.replace(/\{fileName\}/g, outfname).replace(
      /\{url\}/g, url);
    return cmd;
  }
  async exec (cmd) {
    //await后面表达式返回的promise对象，是then的语法糖，await返回then函数的返回值
    //异常需要try/catch自己捕获或外部catch捕获
    const { stdout, stderr } = await exec(cmd);
    return { stdout, stderr };
  }
  async execDownload (url, outfname) {
    let cmd = this.FetchDownLoadCmd(outfname, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet (subData, url) {
    let cmd = this.FetchGetCmd(subData, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet2 (subData, url) {
    var data = querystring.stringify(subData);
    let cmd = this.FetchGetCmd(data, url);
    var result = await this.exec(cmd);
    return result;
  }
  async execPost (subData, url) {
    if (settings.env == 'dev') {
      const rs = await axios.post(url, subData);
      const ret = {
        stdout: JSON.stringify(rs.data)
      }
      return ret;
    }
    let cmd = this.FetchPostCmd(subData, url);
    var result = await this.exec(cmd, {
      maxBuffer: 4096 * 1024
    });
    return result;
  }

  async execPostWithToken (subData, url, token) {
    console.log('start --')
    console.log(subData, url)
    if (settings.env == 'dev') {
      const rs = await axios.post(url, subData, {
        headers: {
          'token': token
        }
      });
      const ret = {
        stdout: JSON.stringify(rs.data)
      }
      console.log('end --')
      return ret;
    }
    let cmd = this.FetchPostCmdWithToken(subData, url, token)
    var result = await this.exec(cmd, {
      maxBuffer: 1024 * 1024 * 15
    });
    var rtn = result.stdout;
    if (rtn) {
      return JSON.parse(rtn);
    } else {
      return null;
    }
  }
  async execPostWithAK (subData, url, ak) {
    let cmd = this.FetchPostCmdWithAK(subData, url, ak);
    var result = await this.exec(cmd, {
      maxBuffer: 1024 * 1024 * 15
    });
    var rtn = result.stdout;
    if (rtn) {
      return JSON.parse(rtn);
    } else {
      return null;
    }
  }
  async execPost2 (subData, url) {
    let cmd = this.FetchPostCmd2(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPost3 (subData, url) {
    let cmd = this.FetchPostCmd3(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execGet3 (url) {
    let cmd = this.FetchGetCmd3(url);
    console.log("execGet3-----01");
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPostESignBao (subData, url) {
    let cmd = this.FetchPostCmd4(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execPostForm (subData, url) {
    let cmd = this.FetchPostCmd5(subData, url);
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  async execCustomPostESignBao (cmd) {
    console.log(cmd);
    var result = await this.exec(cmd);
    return result;
  }
  test () {
    console.log("hello");
  }
}
module.exports = RestClient;
// var x=new RestClient();
// x.execGet("","http://www.163.com").then(function(r){
//   console.log(r.stdout);
//   console.log(r.stderr);
// });
