const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
const { encryptStr, decryptStr } = system;
/**
 * 材料缓存表
 */
module.exports = (db, DataTypes) => {
	return db.define("cacheinfo", {
		cache_info: {
			allowNull: false,
			type: DataTypes.JSON,
			set(value) {
				this.setDataValue('cache_info', buildValue(value, encryptStr));
			},
			get() {
				let value = this.getDataValue("cache_info");
				return buildValue(value, decryptStr);
			}
		},
	}, {
		paranoid: false,//假的删除
		underscored: true,
		version: true,
		freezeTableName: true,
		//freezeTableName: true,
		// define the table's name
		tableName: 'cache_information',
		validate: {

		},
		indexes: [
			// Create a unique index on email
			//  {
			//    unique: true,
			//    fields: ['email']
			//  },
			//
			//  // Creates a gin index on data with the jsonb_path_ops operator
			//  {
			//    fields: ['data'],
			//    using: 'gin',
			//    operator: 'jsonb_path_ops'
			//  },
			//
			//  // By default index name will be [table]_[fields]
			//  // Creates a multi column partial index
			//  {
			//    name: 'public_by_author',
			//    fields: ['author', 'status'],
			//    where: {
			//      status: 'public'
			//    }
			//  },
			//
			//  // A BTREE index with a ordered field
			//  {
			//    name: 'title_index',
			//    method: 'BTREE',
			//    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
			//  }
		]
	});
}

/**
 * 加密解密组装
 * @param {*} value 
 * @param {*} cryptStr 
 */
function buildValue(value, cryptStr) {
	if (value) {
		let newValue = JSON.parse(JSON.stringify(value));
		if (newValue.proposerInfo) {
			if (newValue.proposerInfo.contactInfo) {
				newValue.proposerInfo.contactInfo.phone = cryptStr(newValue.proposerInfo.contactInfo.phone);
			}
			if (newValue.proposerInfo.recipientInfo) {
				newValue.proposerInfo.recipientInfo.phone = cryptStr(newValue.proposerInfo.recipientInfo.phone);
			}
			if (newValue.proposerInfo.principalInfo) {
				newValue.proposerInfo.principalInfo = newValue.proposerInfo.principalInfo.map(val => {
					return {
						...val,
						certificateId: cryptStr(val.certificateId),
						phone: cryptStr(val.phone)
					}
				})
			}
		}
		if (newValue.shareholderData) {
			newValue.shareholderData = newValue.shareholderData.map(val => {
				return {
					...val,
					idNumber: cryptStr(val.idNumber)
				}
			})
		}
		return newValue;
	} else {
		return value;
	}

}

