const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
const { encryptStr, decryptStr } = system;

/**
 * 材料表
 */
module.exports = (db, DataTypes) => {
    return db.define("material", {
        proposerInfo: {
            allowNull: false,
            type: DataTypes.JSON,
            set(value) {
                this.setDataValue('proposerInfo', buildProposerInfo(value, encryptStr));
            },
            get() {
                let value = this.getDataValue("proposerInfo");
                return buildProposerInfo(value, decryptStr);
            }
        },
        shareholderData: {
            allowNull: false,
            type: DataTypes.JSON,
            set(value) {
                this.setDataValue('shareholderData', buildShareholderData(value, encryptStr));
            },
            get() {
                let value = this.getDataValue("shareholderData");
                return buildShareholderData(value, decryptStr);
            }
        },
        implementationPlanInfo: {
            allowNull: false,
            type: DataTypes.JSON
        },
        safetyInfo: {
            allowNull: false,
            type: DataTypes.JSON
        },
        otherMaterialsInfo: {
            allowNull: false,
            type: DataTypes.JSON
        },
        ifDownload: {//是否生成下载文件
            type: DataTypes.BOOLEAN,
            defaultValue: false
        },
        downloadUrl: {
            allowNull: true,
            type: DataTypes.STRING
        }
    }, {
        paranoid: false,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'materials_info',
        validate: {

        },
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}

function buildProposerInfo(value, cryptStr) {
    if (value) {
        let newValue = JSON.parse(JSON.stringify(value));
        if (newValue.contactInfo) {
            newValue.contactInfo.phone = cryptStr(newValue.contactInfo.phone);
        }
        if (newValue.recipientInfo) {
            newValue.recipientInfo.phone = cryptStr(newValue.recipientInfo.phone);
        }
        if (newValue.principalInfo) {
            newValue.principalInfo = newValue.principalInfo.map(val => {
                return {
                    ...val,
                    certificateId: cryptStr(val.certificateId),
                    phone: cryptStr(val.phone)
                }
            })
        }
        return newValue;

    } else {
        return value;
    }
}


function buildShareholderData(value, cryptStr) {
    if (value) {
        let newValue = JSON.parse(JSON.stringify(value));
        newValue = value.map(val => {
            return {
                ...val,
                idNumber: cryptStr(val.idNumber)
            }
        })
        return newValue
    } else {
        return value;
    }
}

