var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
class EcompanyworkCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EcompanyworkCtl));
    this.excelClient = system.getObject("util.excelClient");
  }

  async info(queryobj, qobj, req) {
    try {
      var info = await this.service.getById(qobj.id);
      return system.getResult2(info);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  async companylist(queryobj, qobj, req) {
    var params = qobj.search || {};
    var ecompany = req.session.ecompany;
    if (!ecompany) {
      return system.getResult2({count: 0, rows:[]});
    }

    try {
      params.ecompany_id = ecompany.id;
      var rs = await this.service.pageByCondition(params);
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  // async zccompanylist(queryobj, qobj, req) {
  //   var params = qobj.search || {};
  //
  //   try {
  //     var rs = await this.service.pageByCondition(params);
  //     return system.getResult2(rs);
  //   } catch (e) {
  //     console.log(e);
  //     return system.getErrResult2("您的网络不稳, 请稍后重试");
  //   }
  // }

  async zccompanylist(queryobj, qobj, req) {
    var params = qobj.search || {};
    try {
      return await this.service.pageByCondition(params);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async allExport(queryobj, req, res) {
    var params = JSON.parse(queryobj.search);
    params.currentPage = 1;
    params.pageSize = 60000;

    try {
      var page = await this.service.pageByCondition(params);

      var csvobj = {
        fileName: "工作量确认单" + moment().format("YYYYMMDD") + ".csv",
        rows: page.data.rows,
        opts: {
          fields: ['mtchId', 'com_name', 'username', 'iphone', 'id_nu', 'card_nu', 'send_amount', 'workload','created_time','updated_at'],
          unwind: [],
          unwindBlank: true,
          excelStrings: true,
        },
        headers: {
          'mtchId': '企业id',
          'com_name': "企业名称",
          'username': '姓名',
          'iphone': "手机号",
          'id_nu': "身份证",
          "card_nu": "银行卡号",
          'send_amount': "应发金额",
          'workload': "工作量",
          'created_time': "开始时间",
          'updated_at': "确认时间"
        },
      };
      await this.excelClient.exportCsv(req, res, csvobj);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }





  // async mysave(queryobj, qobj, req) {
  //   qobj = qobj || {};
  //   var ecompany = req.session.ecompany;
  //   if (!ecompany) {
  //     return system.getErrResult2("请先做企业认证");
  //   }

  //   try {
  //     var workload;
  //     if(qobj.id) {
  //       workload = await this.service.findById(qobj.id);
  //       workload.name = qobj.name;
  //       workload.url = qobj.url;
  //       workload.updated_at = new Date();
  //       workload.month = Number(qobj.month.replace("-", ""));
  //       await workload.save();
  //     } else {
  //       workload = {
  //         ecompany_id: ecompany.id,
  //         name: qobj.name,
  //         url: qobj.url,
  //         month: Number(qobj.month.replace("-", "")),
  //       }
  //       workload = await this.service.create(workload);
  //     }
  //     return system.getResult2(workload);
  //   } catch (e) {
  //     console.log(e);
  //     return system.getErrResult2("您的网络不稳, 请稍后重试");
  //   }
  // }

  async zcsave(queryobj, qobj, req) {
    qobj = qobj || {};
    try {
      var workload = {};
      if(qobj.id) {
        workload = await this.service.findById(qobj.id);
      }
      workload.ecompanyId = this.trim(qobj.ecompanyId);
      workload.beginDate = this.trim(qobj.beginDate);
      workload.endDate = this.trim(qobj.endDate);
      workload.workDay = this.trim(qobj.workDay);
      workload.serviceContent = this.trim(qobj.serviceContent);
      workload.unit = this.trim(qobj.unit);
      workload.price = system.y2f(qobj.price);
      workload.payPrice = system.y2f(qobj.payPrice);;
      if(workload.id) {
        workload = await workload.save();
      } else {
        workload = await this.service.create(workload);
      }
      return system.getResult2(workload);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

}
module.exports = EcompanyworkCtl;
