const CtlBase = require("../ctl.base");
var system = require("../../system");

class EtemplatebusiCtl extends CtlBase {
    constructor() {
        super(CtlBase.getServiceName(EtemplatebusiCtl));
        this.esettleSve = system.getObject("service.esettleSve");
    }

    async getlist(queryobj, qobj, req) {
        try {
            var info = await this.service.getlist(qobj);
            return info;
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }


    async mysave(queryobj, qobj, req) {
        try {
            let company_id = qobj.company_id;

            var busidata = await this.service.getinfo(qobj);
            if (busidata.length > 0) {
                return system.getErrResult2("公司已添加");
            }
            if (company_id) {
                var list = await this.esettleSve.findcompanyid(company_id);
                var etebusi = {
                    template_type: qobj.template_type,
                    template_id: qobj.template_id,
                    busi_id: company_id,
                    busi_company_name: list[0].company_name,
                };
                let busi = await this.service.saveto(etebusi);
                if (busi.id > 0) {
                    return system.getResult2(busi.id);
                }
            } else {
                return system.getErrResult2("保存失败");
            }

        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async deleteTetId(queryobj, qobj, req) {
        try {
            let delCout = await this.service.deleteTetId(qobj);
            if(delCout == 1){
                return system.getResult2(delCout);
            }else {
                return system.getErrResult2("删除失败");
            }

        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }

    }


    async suggest(queryobj, qobj, req) {
        var name = this.trim(qobj.name);
        if (!name) {
            return system.getResult2([])
        }

        var list = await this.esettleSve.suggest(name);
        return system.getResult2(list);
    }

    async suggest2(queryobj, qobj, req) {
        var name = this.trim(qobj.name);
        if (!name) {
            return system.getResult2([])
        }

        var list = await this.esettleSve.suggest2(name);
        return system.getResult2(list);
    }


}

module.exports = EtemplatebusiCtl;
