const system = require("../../system");
const Dao = require("../dao.base");

class SalesmanDao extends Dao {
    constructor() {
        super(Dao.getModelName(SalesmanDao));
    }

    async mapSalesmen(params) {
        params = params || {};
        let sql = [];
        sql.push("SELECT");
        sql.push("t1.`busi_id`, ");
        sql.push("t2.`name`, t2.`mobile`, t2.`department_name`");
        sql.push("FROM `p_salesman_busi` t1");
        sql.push("INNER JOIN `p_salesman` t2 ON t1.`sales_id` = t2.`id`");
        sql.push("WHERE 1 = 1 ");

        if (params.busiIds && params.busiIds.length > 0) {
            sql.push("AND t1.`busi_id` IN (:busiIds)");
        }
        let list = await this.customQuery(sql.join(" "), params)
        let map = {};
        for (let item of list) {
            map[item.busi_id] = item;
        }
        return map;
    }
}

module.exports = SalesmanDao;
