const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("oplog", {
    appid: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    appname:{
      type:DataTypes.STRING,
      allowNull: false,
    },
    userid: { type: DataTypes.INTEGER,allowNull: true},
    username:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    sex:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    logLevel: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.logLevel),
      defaultValue: "info",
    },
    op:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    content:{
      type:DataTypes.STRING(4000),
      allowNull: true,
    },
    clientIp:DataTypes.STRING,
    agent:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    flag:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    opTitle:DataTypes.STRING(500),
    app_code:DataTypes.INTEGER(50),
  },{
     paranoid: false,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
    timestamps: true,
     updatedAt:false,
     //freezeTableName: true,
     // define the table's name
      tableName: 'op_log',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
