const system = require("../../system");
const ServiceBase = require("../sve.base");

class BusistatService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(BusistatService));
    }
    async syncDayData(statDay, list) {
        if (!list || list.length == 0) {
            return;
        }
        await this.dao.delByDay(statDay);
        await this.dao.bulkCreate(list);
    }

    async updateDepartmentName(params) {
        return await this.dao.updateDepartmentName(params);
    }

    async countByCondition(params) {
        return await this.dao.countByCondition(params) || 0;
    }

    async listByCondition(params) {
        let list = await this.dao.listByCondition(params);
        this.setF2y(list);
        return list;
    }

    async departmentPage(params) {
        let total = await this.countByCondition(params);
        if (total == 0) {
            return { count: 0, rows: [] };
        }
        let list = await this.listByCondition(params);
        return { count: total, rows: list };
    }

    setF2y(list) {
        if (!list || list.length == 0) {
            return;
        }
        for (let item of list) {
            item.trans_amt = system.f2y(item.trans_amt);
            item.amt = system.f2y(item.amt);
            item.actual_amt = system.f2y(item.actual_amt);
            item.deduct_amt = system.f2y(item.deduct_amt);
            item.income_tax = system.f2y(item.income_tax);
            item.service_tax = system.f2y(item.service_tax);
            item.added_value_tax = system.f2y(item.added_value_tax);
        }
    }
}

module.exports = BusistatService;
