const system = require("../../system");
const ServiceBase = require("../sve.base");
const logCtl = system.getObject("web.oplogCtl");
const moment = require("moment");
const axios = require("axios");
class EcompanyworkService extends ServiceBase {
   constructor() {
      super(ServiceBase.getDaoName(EcompanyworkService));
      this.ecompanyDao = system.getObject("db.ecompanyDao");
      this.callApiUrl = system.callApiUrl().urls;
   }
   async getById(id) {
      var info = await this.dao.model.findOne({where:{id:id}, raw: true});
      if(info && info.ecompanyId) {
         info.ecompany = await this.ecompanyDao.findById(info.ecompanyId);
         if (info.ecompany) {
            info.ecompanyName = info.ecompany.name;
         }
      }
      this.handleDate(info, ["beginDate", "endDate"], "YYYY-MM-DD", -8);
      info.price = system.f2y(info.price);
      info.payPrice = system.f2y(info.payPrice);
      return info;
   }

   async pageByCondition(params) {
      return this.callApi(this.callApiUrl,params);
   }

   async setCompany(list) {
      if (!list || list.length == 0) {
        return;
      }

      var companyIds = [];
      for (var item of list) {
        companyIds.push(item.ecompanyId || 0);
      }
      var companyMap = await this.ecompanyDao.findMapByIds(companyIds, " id, name, contractMobile ");
      for (var item of list) {
        item.ecompany = companyMap["id_" + (item.ecompanyId || 0)] || {};
      }
    }

   async callApi(url, data) {
      logCtl.info({
         optitle: "laowubao接口===>工作量确认单info",
         op: url,
         content: "参数：data=" + data,
         clientIp: ""
      });
      let res = await axios({
         method: 'post',
         url: url,
         data: data
      });
      return res.data;
   }
}
module.exports = EcompanyworkService;
