const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");
const md5 = require("MD5");

class EcontractofflineService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(EcontractofflineService));

        this.etemplateSve = system.getObject("service.etemplateSve");
        this.usereaccountSve = system.getObject("service.usereaccountSve");

    }


    async allList(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);
        var where = {};
        if (params.mchtId) {
            where.mchtId = params.mchtId;
        }
        if (params.mchtName) {
            where.mchtName = params.mchtName;
        }
        if (params.id_name) {
            where.id_name = {
                [this.db.Op.like]: "%" + params.id_name + "%"
            };
        }
        if (params.mobile) {
            where.mobile = params.mobile;
        }
        if (params.id_no) {
            where.id_no = params.id_no;
        }
        var orderby = [
            ["id", 'desc']
        ];
        var page = await this.getPageList(currentPage, pageSize, where, orderby);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["created_at"], null);
            }
        }
        return page;
    }


    async saveEcontractOffline(obj) {
        // var mchtId = obj.mchtId;
        obj.id_no = obj.id_no.toUpperCase();
        // // 1 查签约模板(c_etemplate_busi)
        // var templateIds = await this.etemplateSve.findIdsByCompanyIdAndMainId(mchtId);
        // if (templateIds.idsO.length == 0 && templateIds.idsT.length == 0) {
        //     return this.returnjson(-1,"电子签模板签约主体设置错误，请到bpo后台重新设置");
        // }
        // // 2查签约用户
        // //3方电子签
        // if (templateIds.idsO.length > 0) {
        //     var idsOCOunt = await this.usereaccountSve.getSignAccounts(templateIds.idsO, obj.id_no, obj.id_name);
        // }
        // //2方电子签
        // if (templateIds.idsT.length > 0) {
        //     var idsTCount = await this.usereaccountSve.getSignAccounts_dk(templateIds.idsT, obj.id_no, obj.id_name);
        // }
        //
        // if(idsOCOunt || idsTCount){

        let econtractOffline;
        if (obj.id) {
            econtractOffline = await this.findById(obj.id);
        } else {
            econtractOffline = {isEnabled: 1};
        }
        econtractOffline.mchtId = this.trim(obj.mchtId);
        econtractOffline.mchtName = this.trim(obj.mchtName);
        econtractOffline.id_no = this.trim(obj.id_no);
        econtractOffline.id_name = this.trim(obj.id_name);
        econtractOffline.bank_no = this.trim(obj.bank_no);
        econtractOffline.mobile = this.trim(obj.mobile);
        econtractOffline.fileurl = this.trim(obj.fileurl);
        if (econtractOffline.id) {
            try {
                econtractOffline =  await econtractOffline.save();
            } catch (e) {
                return this.returnjson(-1, "用户已存在");
            }
        } else {
            try {
                econtractOffline = await this.dao.create(econtractOffline);
            } catch (e) {
                return this.returnjson(-1, "用户已存在");
            }
        }
        return system.getResult2(econtractOffline);
        // }

    }

    trim(o) {
        if (!o) {
            return "";
        }
        return o.toString().trim();
    }

    returnjson(code, msg, data) {
        return {
            code: code,
            msg: msg,
            data: data || null
        }
    }

}

module.exports = EcontractofflineService;
