const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");
class EintentionService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EintentionService));

    this.userDao = system.getObject("db.userDao");
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    // name: '',
    // owner_name: '',
    if (params.ownerIds) {
      where.owner_id = {
        [this.db.Op.in]: params.ownerIds
      };
    }

    if (params.name) {
      where.name = {
        [this.db.Op.like]: "%" + params.name + "%"
      };
    }

    if (params.owner_name) {
      where.owner_name = {
        [this.db.Op.like]: "%" + params.owner_name + "%"
      };
    }

    if (params.ecompanyLevel) {
      where.ecompanyLevel = params.ecompanyLevel;
    }

    if (params.ecompanySourceType) {
      where.ecompanySourceType = params.ecompanySourceType;
    }

    if (params.applyStatus) {
      where.status = params.applyStatus;
    }

    if (params.applyId) {
      where.id = params.applyId;
    }

    this.addWhereTime(where, 'created_at', params.createdBegin, params.createdEnd, true);

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "name", "credit_code", "contractName", "contractMobile", "contractPost", "owner_name", "owner_id",
      "ecompanyLevel", "ecompanyLevelName", "ecompanySourceType", "ecompanySourceTypeName",
      "cityCode", "cityName", "pcode", "ccode", "created_at"
    ];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
        this.handleDate(row, ["created_at"], null, -8);
      }
      await this.setOwner(page.rows);
    }
    return page;
  }

  async cancelProject() {
    var endDate = moment().subtract(3, "months").format("YYYY-MM-DD") + " 00:00:00";

    var sql = "UPDATE c_eintention SET deleted_at = NOW() WHERE updated_at <= '" + endDate + "' AND deleted_at IS NULL";
    var rs = await this.dao.customExecAddOrPutSql(sql);
    console.log(rs);
  }

  async setOwner(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    var ownerIds = [];
    for (var row of rows) {
      if (row.owner_id) {
        ownerIds.push(row.owner_id);
      }
    }

    if (ownerIds.length == 0) {
      return;
    }

    var ownerMap = await this.userDao.findMapByIds(ownerIds);
    for (var row of rows) {
      if (row.owner_id) {
        row.owner = ownerMap["id_" + row.owner_id] || {};
      }
    }

    console.log(rows);
  }

  async assignUser(id, assignUserId, opUserId) {
    var intention = await this.findById(id);
    if(!intention) {
      return -1;
    }

    var userMap = await this.userDao.findMapByIds([assignUserId, opUserId]);
    var assignUser = userMap["id_" + assignUserId];
    var opUser = userMap["id_" + opUserId];

    intention.owner_id = assignUser.id;
    intention.owner_name = assignUser.nickName;
    await intention.save();

    var values = "('" + intention.id + "', '" + intention.name + "', '" + opUser.id + "', '" + opUser.nickName + "', '" + assignUser.id + "', '" + assignUser.nickName + "', NOW())";
    var sql = [];
    sql.push("INSERT INTO c_eintention_assign_log");
    sql.push("(intentionId, intentionName, opId, opName, assignId, assignName, created_at)");
    sql.push("VALUES");
    sql.push(values)

    this.customExecAddOrPutSql(sql.join(" "));

    return 1;
  }
}


module.exports = EintentionService;