const system=require("../../system");
const ServiceBase=require("../sve.base");
var settings=require("../../../config/settings");
class OfflinecompanyService extends ServiceBase{
    constructor(){
        super(ServiceBase.getDaoName(OfflinecompanyService));
    }

    async pageByCondition(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);
        var where = {};

        if (params.name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.name + "%"
            };
        }

        var orderby = [
            ["id", 'desc']
        ];
        var attributes = ["id", "company_name", "contact_man", "contact_mobile", "contact_email", "contact_addr", "created_at"];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["created_at"], null, -8);
            }
        }
        return page;
    }

    async updateCreate(params){

        var offlinecompany = await this.dao.findOne({company_name : params.company_name});

        if(offlinecompany && !params.id){
            return {status :-1,msg:"商户已存在"}
        }
        if(params.id){
            var offlinecompanys = await this.dao.findById(params.id);

            offlinecompanys.company_name = params.company_name;
            offlinecompanys.contact_man = params.contact_man;
            offlinecompanys.contact_mobile = params.contact_mobile;
            offlinecompanys.contact_email = params.contact_email;
            offlinecompanys.contact_addr = params.contact_addr;
            var updates = await offlinecompanys.save();
            if(updates.id > 0){
                return {status :0,msg:"修改成功"};
            }
            return {status :-1,msg:"修改失败"};
        }
       var saves = await this.dao.create(params);
       if(saves.id > 0){
            return {status :0,msg:"添加成功"};
       }
        return {status :-1,msg:"添加失败"};
    }


    async suggest(name) {
        return await this.dao.suggest(name);
    }
}
module.exports=OfflinecompanyService;
