{
    template: '${tmpl}',
    data: function () {
        return {
            laststatus: '0',
            detailTitle: '查看详情',
            isAudit: false,
            showReject: false,
            auditId: 0,
            showDetail: false,
            auditLoading: false,
            auditStatus: '1',
            auditRemark: '',
            jobDetail: {},
            ecompany: {},
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                applyBegin:'',
                applyEnd:'',
                auditBegin:'',
                auditEnd:'',
                name:'',
                contractName: '',
                industry:'',
                jdAuthStatus:'',
            },
            industryList: [],
            jdAuthStatusList:[
                {
                    value: '0',
                    label: '待认证'
                },
                {
                    value: '1',
                    label: '认证成功'
                },
                {
                    value: '2',
                    label: '认证失败'
                },
            ],
        }
    },
    mounted: function () {
        this.getIndustryList();
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                currentPage: 1,
                pageSize: 20,
                total : 0,
                list:[],    
                currentPage: 1,
                pageSize: 20,
                total : 0,
                applyBegin:'',
                applyEnd:'',
                auditBegin:'',
                auditEnd:'',
                name:'',
                contractName: '',
                industry:'',
                jdAuthStatus:'',
            }
        },
        resetSearch(all) {
            console.log(all);
            this.search = this.getEmptySearch();
            this.getList();
        },
        getIndustryList() {
            var self = this;
            self.industryList = [];
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "companyIndustry"}).then(cfg=>{
                console.log(JSON.stringify(cfg.data));
                Object.keys(cfg.data).forEach(key=>{
                    self.industryList.push({"label":cfg.data[key],"value":cfg.data[key]});
                });
            });
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/ecompanyCtl/authList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getEcompany(id) {
            var self = this;
            self.$root.postReq("/web/ecompanyCtl/info", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    self.ecompany = d.data;
                    self.showDetail = true;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toaudit(id) {
            this.isAudit = true;
            this.auditRemark = "";
            this.auditStatus = "1";
            this.auditId = id;
            this.detailTitle = "企业认证";
            
            this.getEcompany(id);
        },
        toDetail(id) {
            this.detailTitle = "查看详情";
            this.isAudit = false;
            this.getEcompany(id);
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        showApplys(item) {
            this.$root.pushx({
                title : "查看详情",
                name : "/ejoballapplys",
                params: {ejobId: item.id},
            });
        },
        openLicense() {
            if(this.ecompany && this.ecompany.businessLicense) {
                window.open(this.ecompany.businessLicense);
            }
        },
        audit() {
            var self = this;
            if(self.auditStatus == '2' && !self.auditRemark) {
                self.$message.warning(`请填写驳回原因`);
                return;
            }
            self.$root.postReq("/web/ecompanyCtl/jdAuth", {
                id: self.auditId,
                auditStatus: self.auditStatus,
                auditRemark: self.auditRemark,
            }).then(function (d) {
                self.auditLoading = false;
                if (d.status == 0) {
                    self.$message.success(`操作成功`);
                    self.getList();
                    self.showDetail = false;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
            setTimeout(() => {
                self.auditLoading = false;
            }, 5000);
        },
    },
    vname: "gsb-ejoballmanager"
}