{
    template: '${tmpl}',
    data: function() {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            currentUser: {},
            showEmail: false,
            emailSendText: "发送验证码",
            emailTotalTime: 60,
            emailSvg: "",
            emailLoading: false,
            emailSaveLoading: false,
            emailLock : null,
            emailForm: {
                email: "",
                vcode: "",
                captcha: "",
                emailKey: "",
            },
            emailRules: {
                email : [
                    { required: true, message: '请输入新邮箱', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                vcode : [
                    { required: true, message: '请输入验证码', trigger: 'blur' },
                ],
                captcha : [
                    { required: true, message: '请输入图形验证码', trigger: 'blur' },
                ],
            },
            showPwd: false,
            pwdLoading: false,
            pwdSvg : "",
            pwdSaveLoading: false,
            pwdLock : null,
            pwdSendText: "发送验证码",
            pwdTotalTime: 60,
            pwdForm: {
                mobile: "",
                captcha: "",
                vcode : "",
                captchaKey: "",
                passwd: "",
                passwdConfirm: "",
            },
            pwdRules: {
                vcode : [
                    { required: true, message: '请输入验证码', trigger: 'blur' },
                ],
                captcha : [
                    { required: true, message: '请输入图形验证码', trigger: 'blur' },
                ],
                passwd : [
                    { required: true, message: '请输入新密码', trigger: 'blur' },
                    { min: 6, max: 18, message: '请输入6-18位密码', trigger: 'blur' }
                ],
                passwdConfirm : [
                    { required: true, message: '请再次输入新密码', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
            },

        }
    },
    mounted: function() {
        this.getLoginUser();
    },
    created: function() {
    },
    methods: {
        validfileds(rule, value, callback) {
            if(rule.field == 'contractMobile') {
                if (/^1[23456789]\d{9}$/.test(value)) {
                    return callback();
                } else {
                    return callback(new Error("请输入正确格式的手机号"));
                }
            }

            if(rule.field == 'email') {
                if (this.isEmail(value)) {
                    return callback();
                } else {
                    return callback(new Error("请输入正确的邮箱格式"));
                }
            }

            if(rule.field == 'passwdConfirm') {
                if(this.pwdForm.passwd != this.pwdForm.passwdConfirm) {
                    return callback(new Error("两次密码输入不一致"));
                }
                return callback();
            }
            return callback();
        },
        isEmail(email) {
            var p = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/;
            return p.test(email);
        },
        getLoginUser() {
            var self = this;
            this.$root.postReq("/web/userCtl/info", {
            }).then(function (d) {
                console.log("----------------1111111----------self.pwdForm.mobile");
                if (d.status == 0) {
                    self.currentUser = d.data || {};
                    self.pwdForm.mobile = self.currentUser.mobile || "";
                    console.log(self.pwdForm.mobile, "--------------------------self.pwdForm.mobile");
                }
            });
        },
        captcha(biz) {
            var self = this;
            this.$root.postReq("/api/captchaApi/captcha", {
                width: 120,
                height: 40
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        if(biz == 1) {
                            console.log(d.data.key);
                            self.emailForm.emailKey = d.data.key;
                            $("#emailCaptcha").html(d.data.captcha);
                        } else {
                            self.pwdForm.captchaKey = d.data.key;
                            $("#pwdCaptcha").html(d.data.captcha);

                        }
                    }
                }
            });
        },

        openEmail() {
            this.emailForm = {
                email: "",
                vcode: "",
                captcha: "",
                emailKey: "",
            };
            this.emailSaveLoading = false;
            this.showEmail = true;
            this.captcha(1);
        },
        
        sendEmailCode() {
            var self = this;
            if(!self.isEmail(self.emailForm.email)) {
                self.$refs.emailForm.validateField('email');
                return;
            }
            if(!self.emailForm.captcha) {
                self.$refs.emailForm.validateField('captcha');
                return;
            }
            if(self.emailLoading) {
                return;
            }
            self.emailLoading = true;
            if(self.emailLock) {
                clearInterval(self.emailLock);
            }
            self.emailTotalTime = 59;
            self.emailSendText = self.emailTotalTime + 's后重新发送';

            self.$root.postReq("/web/userCtl/sendEmailCode", self.emailForm).then(function (d) {
                if (d.status == 0) {
                    self.$message.success(`发送成功`);
                    self.emailLock = setInterval(() => {
                        if(self.emailTotalTime > 0) {
                            self.emailTotalTime = self.emailTotalTime - 1;
                            self.emailSendText = self.emailTotalTime + 's后重新发送';
                        } else {
                            self.emailLoading = false;
                            self.emailTotalTime = 60;
                            self.emailSendText = "发送验证码";
                        }
                    }, 1000);
                } else {
                    self.emailLoading = false;
                    self.emailTotalTime = 60;
                    self.emailSendText = "发送验证码";

                    self.$alert(d.msg || '发送失败', '提示', {
                        confirmButtonText: '确定',
                        callback: action => {}
                    });
                    self.captcha(1);
                }
            });
        },

        saveEmail() {
            var self = this;
            self.emailSaveLoading = true;
            self.$refs.emailForm.validate((valid) => {
                if (valid) {
                    this.$root.postReq("/web/userCtl/saveEmail", self.emailForm).then(function (d) {
                        if (d.status == 0) {
                            self.getLoginUser();
                            self.$message.success(`保存成功`);
                            self.showEmail = false;

                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.emailSaveLoading = false;
                    });
                    setTimeout(() => {
                        self.emailSaveLoading = false;
                    }, 5000);
                } else {
                    self.emailSaveLoading = false;
                    return false;
                }
            });
        },

        openPwd() {
            this.pwdForm.captcha = "";
            this.pwdForm.vcode  = "";
            this.pwdForm.captchaKey  = "";
            this.pwdForm.passwd = "";
            this.pwdForm.passwdConfirm = "";

            this.pwdSaveLoading = false;
            this.showPwd = true;
            this.captcha(2);
        },

        sendPwdCode() {
            var self = this;
            if(!self.pwdForm.captcha) {
                self.$refs.pwdForm.validateField('captcha');
                return;
            }
            if(self.pwdLoading) {
                return;
            }
            self.pwdLoading = true;
            if(self.pwdLock) {
                clearInterval(self.pwdLock);
            }
            self.pwdTotalTime = 59;
            self.pwdSendText = self.pwdTotalTime + 's后重新发送';

            self.$root.postReq("/web/userCtl/sendSMSCode", self.pwdForm).then(function (d) {
                if (d.status == 0) {
                    self.$message.success(`发送成功`);
                    self.pwdLock = setInterval(() => {
                        if(self.pwdTotalTime > 0) {
                            self.pwdTotalTime = self.pwdTotalTime - 1;
                            self.pwdSendText = self.pwdTotalTime + 's后重新发送';
                        } else {
                            self.pwdLoading = false;
                            self.pwdTotalTime = 60;
                            self.pwdSendText = "发送验证码";
                        }
                    }, 1000);
                } else {
                    self.pwdLoading = false;
                    self.pwdTotalTime = 60;
                    self.pwdSendText = "发送验证码";

                    self.$alert(d.msg || '发送失败', '提示', {
                        confirmButtonText: '确定',
                        callback: action => {}
                    });
                    self.captcha(2);
                }
            });
        },
        savePwd() {
            var email = email;
            var self = this;
            self.pwdSaveLoading = true;
            self.$refs.pwdForm.validate((valid) => {
                if (valid) {
                    this.$root.postReq("/web/userCtl/savePwd", self.pwdForm).then(function (d) {
                        if (d.status == 0) {
                            self.getLoginUser();
                            self.$message.success(`保存成功`);
                            self.showPwd = false;
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.pwdSaveLoading = false;
                    });
                    setTimeout(() => {
                        self.pwdSaveLoading = false;
                    }, 5000);
                } else {
                    self.pwdSaveLoading = false;
                    return false;
                }
            });
        },
        saveCompany() {
            /*
            var self = this;
            self.submitLoading = true;
            self.$refs['ecompany'].validate((valid) => {
                if (valid) {
                    this.$root.postReq("/web/ecompanyCtl/authsave", {
                        ecompany: self.ecompany
                    }).then(function (d) {
                        if (d.status == 0) {
                            if(d.data) {
                                self.ecompany = d.data;
                            }
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                } else {
                    self.submitLoading = false;
                    return false;
                }
            });
                    */

        },
    },
    vname: "gsb-ecompanysafesettings"
}

