{
  template: '${tmpl}',
  data: function () {
    var that = this;
    var validateMethod = function (rule, value, callback) {
      if (rule.field == "personsSign") {
        if (/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value) == false) {
          return callback(new Error("请输入正确格式的身份证号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "mobile") {
        if (/^1[23456789]\d{9}$/.test(value) == false) {
          return callback(new Error("请输入正确格式的手机号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "vcode") {
        if (that.rcode != value) {
          return callback(new Error("输入验证码有误，请重新输入."));
        }
      }

      if (rule.field == "bankno") {
        if (!value) {
          return callback(new Error("请输入银行卡号"));
        }

        if (value.length >= 30) {
          return callback(new Error("银行卡号位数错误"));
        }

        var num = /^\d*$/;
        if (!num.exec(value)) {
          return callback(new Error("银行卡号只能填写数字"));
        }
      }
      return callback();
    };
    return {
      rcode: "",
      btnloading: false,
      hasEcid: false,
      isyd: false,
      ecid: "",
      ec_company_id: "",
      userMobile: "nomobilessssss",
      from: "",
      userNameDisabled: false,
      personsSignDisabled: false,
      personinfo: {
        ecompany_id: "",
        ecompany_name: "",
        userName: "",
        bankno: "",
        personsSign: "",
        mobile: "",
        vcode: "",
        accountid: "",
      },
      currentAccountId: "",
      accountList: [],
      rs: {
        ecompany_name: [{
          required: true,
          message: '请输入正确服务单位名称',
          trigger: 'blur'
        }],
        userName: [{
          required: true,
          message: '请输入姓名',
          trigger: 'blur'
        }],
        personsSign: [

          {
            required: true,
            message: '请输入身份证号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        mobile: [{
            required: true,
            message: '请输入手机号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        bankno: [{
            required: true,
            message: '请输入银行卡号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
      }
    };
  },
  mounted: function () {
    history.pushState(null, null, document.URL);
    window.addEventListener("popstate",function(e) {
      console.log(e, 1111111111111);
      window.history.go(-1);
    }, false);

    console.log(window.history.length, window.history, "-----------history.replaceState1------------ ");
    console.log("-----------history.replaceState2---22222222222222--------- ");
    window.history = null;
    var self = this;
    /* 检查当前用户的身份证信息是否添加，如果已经添加，那么直接跳转到待签合同页 */
    /* var ecid = localStorage.getItem("ecid"); */
    var ecid = 0;
    var urlparams = this.$root.getHashParameter("ecid") || "";
    var idx = urlparams.indexOf("#/");
    if(idx > 0) {
      ecid = Number(urlparams.substr(0, idx));
    }

    if(!ecid) {
      ecid = localStorage.getItem("ecid");
    }
    console.log(ecid, "-----------ecidecidecidecidecid--------- ");
    var ecompany_id = localStorage.getItem("ecompany_id");

    if (ecid && ecid != "null" && ecid != "undefined") {
      self.hasEcid = true;
      self.ecid = ecid;
      this.$root.postReq("/web/etemplateCtl/info",{id:ecid}).then(function(d){
        if (d.status == 0) {         
          self.personinfo.ecompany_name = d.data.ecompanyName;
          self.personinfo.ecompany_id = d.data.ecompany_id;
          self.ec_company_id = d.data.ecompany_id;
          localStorage.setItem('ecompany_id', d.data.ecompany_id);
        }
      });
    } else if(ecompany_id && ecompany_id != "null" && ecompany_id != "undefined") {
      self.hasEcid = true;
      this.personinfo.ecompany_id = ecompany_id;
      this.$root.postReq("/web/ecompanyCtl/companyInfo", {
        id: ecompany_id
      }).then(function (d) {
        if (d.status == 0) {
          self.personinfo.ecompany_name = d.data.name;
        }
      });
    }

    var applyId = localStorage.getItem("apply_id");
    if (applyId) {
      this.getUserInfo();
    }

    self.from = localStorage.getItem("from") || "";
    if(self.from == "ydh5") {
      self.isyd = true;
    }
    var accid = localStorage.getItem("accid");
    if (accid) {
      if(self.from == "ydh5") {
        self.personsSignDisabled = true;
        self.userNameDisabled = true;
      }
      this.get3rdAccount();
    }
  },
  created: function () {
    this.getUserInfo();
    /* this.getAccountList();
    this.getUserInfo(); */
  },
  methods: {
    getAccountList() {
      var self = this;
      this.$root.postReq("/web/userCtl/accountList", {}).then(function (d) {
        if (d.status == 0) {
          if (d.data) {
            for (var item of d.data) {
              item.label = item.userName + "-" + item.personsSign;
            }
          }
          self.accountList = d.data;
          console.log(d.data);
        }
      });
    },
    changeAccount(value) {
      console.log(this.accountList[Number(value) - 1]);
      var account = this.accountList[Number(value) - 1];

      this.personinfo.personsSign = account.personsSign;
      this.personinfo.mobile = account.mobile;
      this.personinfo.userName = account.userName;
      this.personinfo.userMobile = account.mobile;
      this.personinfo.bankno = account.bankno;
    },
    getUserInfo() {
      var self = this;
      this.$root.postReq("/web/userCtl/getCurrentUser", {}).then(function (d) {            
        if (d.status == 0) {        
          /* self.personinfo.userName = d.data.userName;*/
          var info = (d.data || {}).info || {};
          self.personinfo.personsSign = info.personsSign;
          self.personinfo.mobile = info.mobile;
          self.personinfo.userName = info.userName || "";
          self.personinfo.bankno = info.bankno;

          console.log(d.data);
        }
      });
    },
    get3rdAccount() {
      var self = this;
      this.$root.postReq("/web/userCtl/get3rdAccount", {}).then(function (d) {
        if (d.status == 0) {
          /* self.personinfo.userName = d.data.userName;*/
          var info = d.data || {};
          self.personinfo.userName = info.userName || "";
          self.personinfo.personsSign = info.personsSign;
          self.personinfo.bankno = info.bankno;
          self.personinfo.mobile = info.mobile;

          if(self.from == "ydh5") {
            self.personsSignDisabled = !!self.personinfo.personsSign;
            self.userNameDisabled = !!self.personinfo.userName;
          } else {
          }
          console.log(d.data);
        }
      });
    },
    fetchVcode() {
      var that = this;
      if (/^1[23456789]\d{9}$/.test(this.personinfo.mobile) == false) {
        this.$alert('请输入正确格式的手机号码', '提示', {
          confirmButtonText: '确定',
          callback: action => {}
        });
        return;
      }
      this.btnloading = true;
      /*ajax 调用获取手机验证码,并存储到*/
      this.$root.postReq("/web/userCtl/fetchVcode", {
        mobile: this.personinfo.mobile
      }).then(function (d) {
        if (d.status == 0) {
          that.rcode = d.data.vcodestr;
          setTimeout(() => {
            that.btnloading = false;
          }, 3000);
        }
      });
    },
    nextgo() {
      var that = this;
      this.$root.postReq("/web/ecompanyCtl/findOne", {
        name: that.personinfo.ecompany_name
      }).then(function (d) {
        console.log(d,"6666666666666666666666666666666666666666666666666");
        if (d.status == 0) {
          console.log(d.status,"7777777777777777777777777777");
          that.personinfo.ecompany_id = d.data.id;
          localStorage.setItem('ecompany_id', d.data.id);
        } else {
          that.personinfo.ecompany_name = "";
          that.personinfo.ecompany_id = "";
        }

        that.$refs.pform.validate(valid => {
          if (valid) {
            /*保存者, 调用生成账户接口,生成签名账户,存储accontid到referrerOnlyCode*/
            that.$root.postReq("/web/userCtl/updateSigner", that.personinfo).then(d => {
              if (d.status == 0) {
                localStorage.setItem('ecompany_id', that.personinfo.ecompany_id);
                localStorage.setItem('eaccount_id', d.data.id);
                that.$router.push("/ecompany/waitsign");
              } else {
                that.$alert(d.msg || '签约人信息保存失败', '提示', {
                  confirmButtonText: '确定',
                  callback: action => {}
                });
              }
            });
          }
        });
      });
    },
    findCompany() {
      var self = this;
      var ecompany_name = this.personinfo.ecompany_name || "";
      if (ecompany_name) {
        this.$root.postReq("/web/ecompanyCtl/findOne", {
          name: ecompany_name
        }).then(function (d) {
          if (d.status == 0) {
            self.personinfo.ecompany_id = d.data.id;
            localStorage.setItem('ecompany_id', d.data.id);
            if(self.ec_company_id != self.personinfo.ecompany_id) {
              localStorage.removeItem('ecid');
            } else {
              localStorage.setItem('ecid');
            }
          } else {
            self.personinfo.ecompany_name = "";
            self.personinfo.ecompany_id = "";

            self.$refs.pform.validate(valid => {});
          }
        });
      }
    }
  },
  vname: "gsb-signinfo"
}