const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class BizoptDao extends Dao {
    constructor() {
        super(Dao.getModelName(BizoptDao));
    }
    extraWhere(qobj, qw, qc) {
        qc.raw = true;
        qc.where.business_type = qc.where.business_type && [system.SERVICECODE.EDI, system.SERVICECODE.ICP].includes(qc.where.business_type) ? qc.where.business_type : {
            [this.db.Op.in]: [system.SERVICECODE.EDI, system.SERVICECODE.ICP]
        }
        switch (qobj.bizpath) {
            case "/businessManagement/wailt":
                qc.where.business_status = qc.where.business_status || {
                    [this.db.Op.in]: [system.BUSSTATUS.WAITINGSCHEME, system.BUSSTATUS.WAITINGCONFIRM]
                }
                break
            case "/businessManagement/all":
                break
        }
        qc.include = [
            {
                model: this.db.models.scheme,
                attributes: ["scheme_status"]
            }
        ]
        return qw;
    }
    async findBizAndSheme(id) {
        const result = await this.model.findOne({
            where: {
                id
            },
            include: [
                {
                    model: this.db.models.scheme,
                    raw: false
                }
            ],
            raw: false
        });
        return result;
    }
}
module.exports = BizoptDao;
