const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class DeliverDao extends Dao {
    constructor() {
        super(Dao.getModelName(DeliverDao));
    }
    extraWhere(qobj, qw, qc) {
        qc.raw = true;
        qc.where.product_code = qc.where.product_code && [system.SERVICECODE.EDI, system.SERVICECODE.ICP].includes(qc.where.product_code) ? qc.where.product_code : {
            [this.db.Op.in]: [system.SERVICECODE.EDI, system.SERVICECODE.ICP]
        }

        switch (qobj.bizpath) {
            case "/deliveryManagement/wait":
                qc.where.delivery_status = qc.where.delivery_status || {
                    [this.db.Op.in]: [system.SERVERSESTATUS.RECEIVED, system.SERVERSESTATUS.COLLECTING,
                    system.SERVERSESTATUS.SUBMITING, system.SERVERSESTATUS.DISPOSEING
                    ]
                }
                break
            case "/deliveryManagement/all":
                break
        }
        return qw;
    }

    async findInfo(pobj) {
        const result = await this.model.findOne({
            where: {
                id: pobj.id
            },
            include: [
                {
                    model: this.db.models.qualification,
                    attributes: ['id', 'certificateNumber', 'businessTypes', 'businessScope', 'serviceProject', 'startAt', 'endAt', 'file'],
                    raw: false
                }, {
                    model: this.db.models.material,
                    raw: false
                }
            ],
            raw: false
        });
        return result;
    }
}
module.exports = DeliverDao;
