const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class MaterialDao extends Dao {
    constructor() {
        super(Dao.getModelName(MaterialDao));
    }

    async createOrUpdate(pobj, t) {
        const materialData = await this.findOne({
            deliver_id: pobj.deliver_id
        });
        let result = {};
        let dataInfo = {
            proposerInfo: pobj.cache_info.proposerInfo,
            shareholderData: pobj.cache_info.shareholderData,
            implementationPlanInfo: pobj.cache_info.implementationPlanInfo,
            safetyInfo: pobj.cache_info.safetyInfo,
            otherMaterialsInfo: pobj.cache_info.otherMaterialsInfo,
            deliver_id: pobj.deliver_id
        }
        if (materialData) {
            //更新
            await this.updateByWhere(dataInfo, {
                deliver_id: pobj.deliver_id
            }, t);
            result = { id: materialData.id }
        } else {
            // 创建
            let data = await this.create(dataInfo, t);
            result = { id: data.id };
        }
        return result
    }

}
module.exports = MaterialDao;
