const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
class SchemeService extends ServiceBase {
    constructor() {
        super("bizchance", ServiceBase.getDaoName(SchemeService));
        this.bizoptDao = system.getObject("db.bizchance.bizoptDao");
        this.statuslogDao = system.getObject("db.bizchance.statuslogDao");

    }
    async create(data) {
        // TODO: 权限判断
        let bizData = await this.bizoptDao.findOne({
            id: data.bizopt_id
        });
        if (!bizData) {
            throw new Error("查不到该商机");
        }
        if ([system.BUSSTATUS.CLOSED, system.BUSSTATUS.SUCCESS, system.BUSSTATUS.WAITINGCONFIRM].includes(bizData.business_status)) {
            throw new Error("此商机状态下不可操作");
        }
        let schemeData = await this.dao.findOne({
            bizopt_id: data.bizopt_id
        })
        if (schemeData && [system.SCHEMESTATUS.WAITINGCONFIRM, system.SCHEMESTATUS.CLOSED].includes(schemeData.scheme_status)) {
            throw new Error("此方案状态下不可操作");
        }
        if (!schemeData) {
            // TODO: scheme_number  提交到腾讯获取 方案编号
            data.scheme_number = "TX回传"
        }

        return this.db.transaction(async (t) => {
            /**
             * 1. 更改 商机状态
             * 2. 查询 是否有方案及方案状态
             * 3. 新增 或更改 方案
             * 4. 添加 状态记录更改
             * TODO:5. 传给腾讯状态
             */
            try {
                await this.bizoptDao.updateByWhere({
                    business_status: system.BUSSTATUS.WAITINGCONFIRM
                }, {
                    id: data.bizopt_id
                }, t);
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.BIZ,
                    flow_id: data.bizopt_id,
                    status_code: system.BUSSTATUS.WAITINGCONFIRM
                });
                let scheme_id = null;
                if (schemeData) {
                    await this.dao.updateByWhere({
                        ...data,
                        demand_code: bizData.demand_code,
                        scheme_status: system.SCHEMESTATUS.WAITINGCONFIRM
                    }, {
                        id: schemeData.id
                    }, t);
                    scheme_id = schemeData.id
                } else {
                    let schemeResult = await this.dao.create({
                        ...data,
                        demand_code: bizData.demand_code,
                        scheme_status: system.SCHEMESTATUS.WAITINGCONFIRM,
                        bizopt_id: data.bizopt_id
                    }, t);
                    scheme_id = schemeResult.id;
                }
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.SCHEME,
                    flow_id: scheme_id,
                    status_code: system.SCHEMESTATUS.WAITINGCONFIRM
                });
                return { bizId: data.bizopt_id };
            } catch (err) {
                console.log(err)
            }

        });

    }
}
module.exports = SchemeService;
