const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
class DeliverService extends ServiceBase {
    constructor() {
        super("delivery", ServiceBase.getDaoName(DeliverService));
        this.cacheinfoDao = system.getObject("db.delivery.cacheinfoDao");
        this.materialDao = system.getObject("db.delivery.materialDao");
        this.statuslogDao = system.getObject("db.bizchance.statuslogDao");
        this.qualificationDao = system.getObject("db.delivery.qualificationDao");
    }

    async temporarySave(pobj) {
        const deliverData = await this.dao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("没有关联的交付单");
        }
        let result = await this.cacheinfoDao.createOrUpdate(pobj);
        return result;
    }

    async findTemporary(pobj) {
        return this.cacheinfoDao.findOne({
            deliver_id: pobj.deliver_id
        });
    }

    async submitMaterials(pobj) {
        /**
         * 1.此状态下是否可以提交材料
         * 2.同步暂存数据表
         * 3.存储到材料表
         * 4.更改 交付单流转状态
         * 5.推送到腾讯
         */
        const deliverData = await this.dao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData || ![
            system.SERVERSESTATUS.COLLECTING,
            system.SERVERSESTATUS.SUBMITING,
            system.SERVERSESTATUS.DISPOSEING
        ].includes(deliverData.delivery_status)) {
            throw new Error("此交付单不可提交材料");
        }
        return this.db.transaction(async (t) => {
            await this.materialDao.createOrUpdate(pobj, t);
            await this.cacheinfoDao.createOrUpdate(pobj, t);
            if (deliverData.delivery_status === system.SERVERSESTATUS.COLLECTING) {
                await this.dao.updateByWhere({
                    delivery_status: system.SERVERSESTATUS.SUBMITING
                }, {
                    id: pobj.deliver_id
                }, t);
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.DELIVERY,
                    flow_id: pobj.deliver_id,
                    status_code: system.SERVERSESTATUS.SUBMITING
                }, t);
            }

            return "SUCCESS"
        });
    }

    async findInfo(pobj) {
        /**
         * 交付单表 关联  材料表(材料基本信息、邮寄信息) 、 资质信息表
         */
        let result = await this.dao.findInfo(pobj);
        if (!result) {
            throw new Error("交付单不可查看");
        }
        return result;
    }

    async changeDeliveryStatus(pobj) {
        /**
         * 判断 交付单状态下能否更新
         */
        const deliverData = await this.dao.findOne({
            id: pobj.id
        });
        if (!deliverData) {
            throw new Error("没有此交付单");
        }
        if (![system.SERVERSESTATUS.SUBMITING, system.SERVERSESTATUS.POSTING].includes(deliverData.delivery_status)) {
            throw new Error("此状态下不可手动更新办理状态");
        }
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.SUBMITING:
                status = system.SERVERSESTATUS.DISPOSEING
                break
            case system.SERVERSESTATUS.POSTING:
                status = system.SERVERSESTATUS.SUCCESS
                break
        }
        await this.dao.updateByWhere({
            delivery_status: status
        }, {
            id: pobj.id
        })
        this.statuslogDao.create({
            flow_type: system.FLOWCODE.DELIVERY,
            flow_id: pobj.id,
            status_code: status
        });
        return "success"
    }

    async addQualification(pobj) {
        const deliverData = await this.dao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("查不到交付单");
        }
        if (deliverData.delivery_status !== system.SERVERSESTATUS.DISPOSEING) {
            throw new Error("该交付单状态下不可提交");
        }
        let result = await this.qualificationDao.createOrUpdate(pobj);
        return result;
    }

    async closeDeliver(pobj) {
        const deliverData = await this.dao.findOne({
            id: pobj.id
        });
        if (!deliverData) {
            throw new Error("查不到交付单");
        }
        if (![system.SERVERSESTATUS.RECEIVED, system.SERVERSESTATUS.COLLECTING].includes(deliverData.delivery_status)) {
            throw new Error("该交付单状态下不可提交");
        }
        await this.dao.updateByWhere({
            delivery_status: system.SERVERSESTATUS.CLOSED,
            close_reason: pobj.close_reason
        }, {
            id: pobj.id
        });
        this.statuslogDao.create({
            flow_type: system.FLOWCODE.DELIVERY,
            flow_id: pobj.id,
            status_code: system.SERVERSESTATUS.CLOSED
        });
        return "success"
    }

    async addMail(pobj) {
        let result = await this.dao.findInfo(pobj);
        if (!result) {
            throw new Error("交付单不可查看");
        }
        if (result.qualification) {
            throw new Error("请先上传资质信息");
        }
        if (result.delivery_status !== system.SERVERSESTATUS.DISPOSEING) {
            throw new Error("该状态下不可填写邮寄信息");
        }
        const { material: { proposerInfo } } = result;
        proposerInfo.recipientInfo = pobj.recipientInfo;

        return this.db.transaction(async (t) => {
            await this.materialDao.updateByWhere({
                proposerInfo
            }, {
                id: material.id
            }, t)

        });
        /**
         * 保存 邮寄信息
         * 更改流转状态
         */

    }

}
module.exports = DeliverService;
