const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class MsgNoticeService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(MsgNoticeService));
    this.userDao = system.getObject("db.auth.userDao");
    this.msghistoryDao = system.getObject("db.msg.msghistoryDao");
  }
  getApp(appkey) {
    return this.cacheManager["AppCache"].cacheApp(appkey);
  }

  async getUserList(userId) {
    var list = await this.dao.model.findAll({
      where: {
        fromId: userId
      },
      order: [
        ["updated_at", "DESC"]
      ],
      raw: true
    });

    if (!list || list.length == 0) {
      return [];
    }

    var msgIds = [];
    var businessLicenseIds = [];
    var userIds = [];
    for (var item of list) {
      msgIds.push(item.lastMsgId);
      businessLicenseIds.push(item.businessLicense_id);
      userIds.push(item.toId);
    }

    var msgMap = [];
    var businessLicenseMap = [];
    var userMap = [];
    var unreadMap = [];

    // 最后一条聊天记录
    if (msgIds.length > 0) {
      var msgList = await this.msghistoryDao.customQuery("SELECT * FROM msghistory WHERE id IN (" + msgIds.join(",") + ") ");
      msgList.forEach(item => {
        msgMap["id" + item.id] = item;
      });
    }
    // 最后一次聊天关联执照
    if (businessLicenseIds.length > 0) {
      var licenseList = await this.businesslicenseDao.customQuery("SELECT * FROM yz_business_license WHERE id IN (" + businessLicenseIds.join(",") + ") ");

      var serviceTypeIds = [];
      for (var item of licenseList) {
        serviceTypeIds.push(item.serviceTypeOneId);
        serviceTypeIds.push(item.serviceTypeTwoId);
      }

      if (serviceTypeIds.length > 0) {
        var sql = "SELECT id, name FROM `p_service_type` WHERE id IN (" + serviceTypeIds.join(",") + ") ";
        var typeList = await this.dao.customQuery(sql);

        var typeMap = [];
        if (typeList && typeList.length > 0) {
          for (var t of typeList) {
            typeMap["type_id_" + t.id] = t.name;
            if (t.id == item.serviceTypeOneId) {
              item.serviceTypeOneName = t.name;
            } else if (t.id == item.serviceTypeTwoId) {
              item.serviceTypeTwoName = t.name;
            } else {}
          }
        }
      }

      for (var item of licenseList) {
        item.serviceTypeOneName = typeMap["type_id_" + item.serviceTypeOneId];
        item.serviceTypeTwoName = typeMap["type_id_" + item.serviceTypeTwoId];
      }

      licenseList.forEach(item => {
        businessLicenseMap["id" + item.id] = item;
      });
    }
    // 聊天好友用户信息
    if (userIds.length > 0) {
      var userList = await this.userDao.customQuery("SELECT * FROM p_user WHERE id IN (" + userIds.join(",") + ") ");
      userList.forEach(item => {
        userMap["id" + item.id] = item;
      });
    }

    // 未读消息数量
    var unreadList = await this.userDao.customQuery("SELECT senderId, COUNT(1) AS num FROM `msghistory` WHERE isRead = 0 AND targetId = " + userId + "  GROUP BY senderId ");
    unreadList.forEach(item => {
      unreadMap["id" + item.senderId] = item.num;
    });

    var rs = [];
    for (var i in list) {
      var item = list[i];
      item.lastMsg = msgMap["id" + item.lastMsgId];
      item.businessLicense = businessLicenseMap["id" + item.businessLicense_id];
      item.friend = userMap["id" + item.toId];
      item.unreadCount = unreadMap["id" + item.toId] || 0;
      rs.push(item);
    }

    return rs;
  }

  async countUnread(userId) {
    debugger;
    var unreadList = await this.userDao.customQuery("SELECT COUNT(1) AS num FROM `msghistory` WHERE isRead = 0 AND targetId = " + userId);
    var count = 0;
    if (unreadList && unreadList.length > 0) {
      count = unreadList[0].num || 0;
    }

    return count;
  }
}
module.exports = MsgNoticeService;