var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require("moment");

class EcontractofflineCtl extends CtlBase {
    constructor() {
        super(CtlBase.getServiceName(EcontractofflineCtl));
    }

    async saveEcontractOffline(queryobj, obj, req) {
        try {
            return await this.service.saveEcontractOffline(obj);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }


    async allList(queryobj, obj, req) {
        var params = obj.search || {};
        try {
            var page = await this.service.allList(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async info(queryobj, qobj, req) {
        var id = Number(qobj.id);
        try {
            var info = await this.service.findById(id);
            if (info) {
                if (info.created_at) {
                    info.created_at = moment(info.created_at).format("YYYY-MM-DD HH:mm:ss");
                }
            }
            return system.getResult2(info);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

}

module.exports = EcontractofflineCtl;
