var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require("moment");
class EjobrosterCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EjobrosterCtl));
    this.ejobapplySve = system.getObject("service.ejobapplySve");
    this.esettleSve = system.getObject("service.esettleSve");
    this.ecompanySve = system.getObject("service.ecompanySve");
  }

  async list(queryobj, qobj, req) {
    var params = qobj.search || {};
    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }


  async saveRoster(queryobj, qobj, req) {
    try {
      var rs = await this.service.saveRoster(req.session.user.id, qobj.url);
      if(rs.code == 0) {
        return system.getErrResult2(rs.msg || "文件解析失败");
      }

      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async parseRoster(queryobj, qobj, req) {
    try {
      var rs = await this.service.parseRoster(req.session.user.id, qobj.url);
      if(rs.code == 0) {
        return system.getErrResult2(rs.msg || "文件解析失败");
      }

      return system.getResult2(rs.data);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = EjobrosterCtl;