const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("ejobapply", {
    ecompany_id: DataTypes.INTEGER,
    ejob_id: DataTypes.INTEGER,
    econtract_id: DataTypes.INTEGER,
    user_id: DataTypes.INTEGER,
    usereaccount_id: DataTypes.INTEGER,
    statusName: {
      type: DataTypes.STRING(20),
      defaultValue: "待审核",
    },
    status: {
      // 申请状态 0:待审核,1:待签约,2:已签约, 3:进行中, 4:已完成, 5:已撤销, 6:已驳回, 7:已失效
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.applyStatus),
      set: function (val) {
        this.setDataValue("status", val);
        this.setDataValue("statusName", uiconfig.config.pdict.applyStatus[val]);
      },
      defaultValue: "0",
    },
    audit_at: DataTypes.DATE,
    audit_id: DataTypes.INTEGER,
    auditRemark: DataTypes.STRING(200),
    notifyTimes: DataTypes.INTEGER,
    apply_at: DataTypes.DATE,
    sign_at: DataTypes.DATE,
    cancel_at: DataTypes.DATE,
    applyType: DataTypes.INTEGER,
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_ejob_apply',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}