const system = require("../../system");
const ServiceBase = require("../sve.base");

class DepartmentService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(DepartmentService));
    }

    async suggestByName(name){
        return await this.dao.suggest(name);
    }

    async dict() {
        let sql = "SELECT id, name FROM p_department WHERE deleted_at IS NULL";
        return await this.customQuery(sql) || [];
    }

    async mapDict() {
        let result = {};
        let list = await this.dict();
        for (let item of list) {
            result[item.id] = item;
        }
        return result;
    }
}

module.exports = DepartmentService;
