{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            curStatus: '0',
            jobId : 0,
            applyStatusList:[],
            identityTypeList:[],
            eduTypeList:[],
            multipleSelection:[],
            showAll : true,
            showDetail: false,
            interviewLoading: false,
            showInterviewTime: false,
            showAudit: false,
            auditStatus: "1",
            auditRemark: "",
            auditIds:[],
            auditLoading: false,
            interviewTime: "",
            interviewIds : [],
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                userName: '',
                mobile: '',
                applyStatus : '0',
                identityType: '',
                sex:'',
                edu: '',
                age: '',
                signBegin : '',
                signEnd : '',
                auditBegin: '',
                auditEnd: '',
                cancelBegin: '',
                cancelEnd: '',
            },
            jobDetail: {
                id: 0,
                name: '',
                num: '',
                sexName: '',
                settleTypeName: '',
                jobTimes: [],
            },
            applyDetail: {
                id: '',
                eaccount: {},
            },
        }
    },
    mounted: function () {
        this.jobId = this.$router.currentRoute.query.ejobId;

        this.getApplyStatusList();
        this.getIdentityTypeList();
        this.getEduTypeList();
        this.getJobDetail();
        this.resetSearch();
    },
    created: function () {
    },
    methods: {
        getApplyStatusList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "applyStatus"}).then(cfg=>{
                self.applyStatusList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.applyStatusList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getIdentityTypeList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "identityType"}).then(cfg=>{
                self.identityTypeList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.identityTypeList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getEduTypeList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "eduType"}).then(cfg=>{
                self.eduTypeList = [];
                Object.keys(cfg.data).forEach(key=>{
                    self.eduTypeList.push({"label":cfg.data[key],"value":key});
                });
            });
        },
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                applyStatus : '0',
                identityType: '',
                sex:'',
                edu: '',
                age: '',
                signBegin : '',
                signEnd : '',
                auditBegin: '',
                auditEnd: '',
                cancelBegin: '',
                cancelEnd: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        getJobDetail() {
            var self = this;
            self.$root.postReq("/web/ejobCtl/jobInfo", {
                jobId: self.jobId,
                pattern: {
                    datePattern : "YYYY-MM-DD HH:mm:ss",
                    timesPattern : "YYYY.MM.DD"
                }
            }).then(function (d) {
                if (d.status == 0) {
                    self.jobDetail = d.data;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/ejobapplyCtl/jobAllApplys", {
                jobId: self.jobId,
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        handleSelectionChange(v) {
            this.multipleSelection = v || [];
        },
        validfileds(rule, value, callback) {
            return callback();
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        doExport() {
            this.$message.warning(`该功能正处于紧张开发中...`);
        },
        openDetail(id) {
            var self = this;
            this.$root.postReq("/web/ejobapplyCtl/applyInfo", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    self.applyDetail = d.data || {};
                    self.showDetail = true;
               } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        signNotify(id) {
            this.interviewIds = [id];
            this.interviewTime = "";
            this.showInterviewTime = true;
        },
        batchNotify() {
            if(!this.multipleSelection || this.multipleSelection.length == 0) {
                this.$alert('请先选择零工', '提示', {
                    confirmButtonText: '确定',
                    callback: action => {}
                });
                return;
            }

            this.interviewIds = [];
            for (var sec of this.multipleSelection) {
                this.interviewIds.push(sec.id);
            }

            this.interviewTime = "";
            this.showInterviewTime = true;
        },
        cancelInterview() {
            this.showInterviewTime = false;
        },
        notifyInterview() {
            var self = this;
            self.interviewLoading = true;
            if(!this.interviewTime) {
                self.$message.warning(`请选择面试时间`);
                return;
            }
            this.$root.postReq("/web/ejobapplyCtl/notifyInterview", {
                ids: self.interviewIds,
                interviewTime: self.interviewTime
            }).then(function (d) {
                if (d.status == 0) {
                    self.showInterviewTime = false;
                    self.$message.warning(`通知完成`);
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
                self.interviewLoading = false;
            });
            setTimeout(() => {
                self.interviewLoading = false;
            }, 5000);
        },
        signleAudit(id) {
            this.auditIds = [id];
            this.auditStatus = "1";
            this.showAudit = true;
        },
        batchAudit(ids) {
            if(!this.multipleSelection || this.multipleSelection.length == 0) {
                this.$alert('请先选择零工', '提示', {
                    confirmButtonText: '确定',
                    callback: action => {}
                });
                return;
            }

            this.auditIds = [];
            for (var sec of this.multipleSelection) {
                this.auditIds.push(sec.id);
            }

            this.auditStatus = "1";
            this.showAudit = true;
        },
        audit() {
            var self = this;
            if(self.auditStatus == '6' && (!self.auditRemark || !self.auditRemark.trim())) {
                self.$alert('请输入驳回原因', '提示', {
                    confirmButtonText: '确定',
                    callback: action => {}
                });
                return;
            }
            self.auditLoading = true;
            self.$root.postReq("/web/ejobapplyCtl/audit", {
                ids: self.auditIds,
                auditStatus: self.auditStatus,
                auditRemark: self.auditRemark,
            }).then(function (d) {
                if (d.status == 0) {
                    self.showAudit = false;
                    self.$message.warning(`审核完成`);
                    self.getList();
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
                self.auditLoading = false;
            });
            setTimeout(() => {
                self.auditLoading = false;
            }, 5000);

        },
        showContract(contractId) {
            var self = this;
            self.$root.postReq("/web/econtractCtl/getContractUrl", {
                id: contractId,
            }).then(function (d) {
                if (d.status == 0) {
                    window.open(d.data);
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
    },
    vname: "gsb-ejoballapplys"
}