{
  template: '${tmpl}',
  data: function () {
    var that = this;
    var validateMethod = function (rule, value, callback) {
      if (rule.field == "personsSign") {
        if (/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value) == false) {
          return callback(new Error("请输入正确格式的身份证号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "mobile") {
        if (/^1[23456789]\d{9}$/.test(value) == false) {
          return callback(new Error("请输入正确格式的手机号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "vcode") {
        if (that.rcode != value) {
          return callback(new Error("输入验证码有误，请重新输入."));
        }
      }

      if (rule.field == "bankno") {
        if (!value) {
          return callback(new Error("请输入银行卡号"));
        }

        if (value.length >= 30) {
          return callback(new Error("银行卡号位数错误"));
        }

        var num = /^\d*$/;
        if (!num.exec(value)) {
          return callback(new Error("银行卡号只能填写数字"));
        }
      }
      return callback();
    };
    return {
      ak: "",
      rcode: "",
      btnloading: false,
      hasEcid: false,
      isyd: false,
      ecid: "",
      ec_company_id: "",
      userMobile: "nomobilessssss",
      from: "",
      personinfo: {
        dkcompany_id: "",
        dkcompany_name: "",
        userName: "",
        bankno: "",
        personsSign: "",
        mobile: "",
        vcode: "",
        accountid: "",
      },
      currentAccountId: "",
      accountList: [],
      rs: {
        ecompany_name: [{
          required: true,
          message: '请输入正确服务单位名称',
          trigger: 'blur'
        }],
        userName: [{
          required: true,
          message: '请输入姓名',
          trigger: 'blur'
        }],
        personsSign: [
          {
            required: true,
            message: '请输入身份证号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        mobile: [{
            required: true,
            message: '请输入手机号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        bankno: [{
            required: true,
            message: '请输入银行卡号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
      }
    };
  },
  mounted: function () {
    var self = this;
    /* 检查当前用户的身份证信息是否添加，如果已经添加，那么直接跳转到待签合同页 */
    /* var ecid = localStorage.getItem("ecid"); */

    self.ak = localStorage.getItem("ak") || "";

    var ecid = this.getEcid();
    console.log(ecid, "-----------ecidecidecidecidecid--------- ");
    if (ecid && ecid != "null" && ecid != "undefined") {
      self.hasEcid = true;
      self.ecid = ecid;
      this.$root.postReq("/web/dksignCtl/templateInfo",{id:ecid}).then(function(d){
        if (d.status == 0) {
          self.personinfo.dkcompany_name = d.data.dkcompanyName;
          self.personinfo.dkcompany_id = d.data.dkcompany_id;
          console.log(self.personinfo.dkcompany_name, "666666666666666666666666666666");
        }
      });
    }

    this.getTsAccount();

  },
  created: function () {
    /* this.getAccountList();
    this.getUserInfo(); */
  },
  methods: {
    getEcid() {
      var ecid = 0;
      var urlparams = this.$root.getHashParameter("ecid") || "";
      var idx = urlparams.indexOf("#/");
      if(idx > 0) {
        ecid = Number(urlparams.substr(0, idx));
      }
      if(!ecid) {
        ecid = localStorage.getItem("ecid");
      }
      return ecid || 0;
    },
    getTsAccount() {
      var self = this;
      this.$root.postReq("/web/dksignCtl/getTsAccount", {
        ak: self.ak
      }).then(function (d) {
        if (d.status == 0) {
          var info = d.data || {};
          self.personinfo.userName = info.userName || "";
          self.personinfo.personsSign = info.personsSign || "";
          self.personinfo.bankno = info.bankno || "";
          self.personinfo.mobile = info.mobile || "";
        }
      });
    },
    nextgo() {
      var that = this;
      that.$refs.pform.validate(valid => {
        if (valid) {
          /*保存者, 调用生成账户接口,生成签名账户,存储accontid到referrerOnlyCode*/
          that.$root.postReq("/web/dksignCtl/updateDKSigner", that.personinfo).then(d => {
            if (d.status == 0) {
              localStorage.setItem('eaccount_id', d.data.id);
              that.$router.push("/ecompany/twaitsign");
            } else {
              that.$alert(d.msg || '签约人信息保存失败', '提示', {
                confirmButtonText: '确定',
                callback: action => {}
              });
            }
          });
        }
      });
    },
  },
  vname: "gsb-tsigninfo"
}