var WEBBase = require("../../web.base");
var system = require("../../../system");
class EnterpriseQueryAPI extends WEBBase {
    constructor() {
        super();
        this.enterSve = system.getObject("service.enterprise.enterpriseSve");
    }

    /**
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "gxCountByAuthor"://获取企业高薪信息数量
            case "gxListByAuthor"://获取企业高薪信息列表
            case "gameCountByAuthor"://获取企业游戏出版及运营数量
            case "gameListByAuthor"://获取企业游戏出版及运营信息列表
            case "licenseCountByAuthor"://获取企业证照信息数量
            case "licenseListByAuthor"://获取企业证照信息列表
            case "ipCountByAuthor"://获取企业域名信息数量
            case "ipListByAuthor"://获取企业域名信息列表
            case "getQccBranches"://获取企业的分支机构（从企查查获取）
            case "getcountAll"://获取企业所有证照数量
                opResult = await this.enterSve.opReqResult(pobj, req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = EnterpriseQueryAPI;