var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");

class PushAliInfo extends APIBase {
    constructor() {
        super();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    }

    /**
     * 推送阿里商标跟进信息
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async tmNote(pobj, qobj, req) {
        var reqPushParams = {
            reqbody: {
                BizId: pobj.intentionBizId,
                Note: pobj.note.replace(/<[^>]+>/g, "")
            },
            appInfo: {uapp_id: 18}
        };
        let result = await this.utilsPushSve.business2Channel(reqPushParams, "pushAliTmNote");
        if (result && result.data) {
            return result.data;
        }
        return result;
    }

    /**
     * 推送阿里工商跟进信息
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async icNote(pobj, qobj, req) {
        var reqPushParams = {
            reqbody: {
                IntentionBizId: pobj.intentionBizId,
                Type: 1,// 1需求，2订单
                Note: pobj.note.replace(/<[^>]+>/g, "")
            },
            appInfo: {uapp_id: 18}
        };
        let result = await this.utilsPushSve.business2Channel(reqPushParams, "pushAliIcNote");
        if (result && result.data) {
            return result.data;
        }
        return result;
    }
}

module.exports = PushAliInfo;