const CacheBase=require("../cache.base");
const system=require("../../system");
// const OpenplatformWxop =  require("../../wxop/impl/openplatformWxop");
/**
 * 微信开放平台 公众号或小程序的接口调用凭据(授权方令牌)缓存（2小时后失效）
 */
class WxTokenCache extends CacheBase{
   constructor(){
     super();
     this.prefix="wx_toekn_wx4c91e81bbb6039cd";
     this.restClient = system.getObject("util.restClient");
     this.wxTokenSve = system.getObject("service.common.wxTokenSve");
   }
    desc() {
        return "应用UI配置缓存";
    }
    prefix() {
        return "wx_toekn_wx4c91e81bbb6039cd";
    }
   async get(){//公众号appid
      var key = this.prefix;
      var result = await this.redisClient.get(key);
      var obj = null;
      if(result){
         console.log(result,"缓存中获取token+++++++++++++++++++++++");
         obj=JSON.parse(result);
      }
      if(!obj){//无缓存
         var newobj = await this.wxTokenSve.getToken();
         console.log(newobj);
         if(newobj && newobj.access_token){
            var newobjstring=JSON.stringify(newobj);
            // await this.redisClient.set(key,newobjstring);
            // this.redisClient.client.expire(key, 7000);
            await this.redisClient.setWithEx(key,newobjstring,7000);
            return newobj;
         }else{
            return null;
         }
      }
      return obj;
   }
  
}
module.exports=WxTokenCache;