const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//区分渠道的uappid
const uappId = {
    'ali': "18",  //(阿里icp、edi)
    'baidu': "44",   //(百度icp、edi)
    'zc360': "50",  //360icp、edi
    "ename": "52" //易名
}
//tui song baidu zhuanyong pinyin 2020-11-6
const cityLetter = {
    "北京": "BEIJING",
    "上海": "SHANGHAI",
    "福建": "FUJIAN",
    "广西": "GUANGXI",
    "广东": "GUANGDONG",
    "安徽": "ANHUI",
    "河南": "HENAN",
    "湖北": "HUBEI",
    "浙江": "ZHEJIANG",
    "江苏": "JIANGSU",
    "山东": "SHANDONG",
    "陕西": "SHANXI_SHAN",
    "宁夏": "NINGXIA",
    "甘肃": "GANSU",
    "新疆": "XINJIANG",
    "青海": "QINGHAI",
    "天津": "TIANJIN",
    "重庆": "CHONGQING",
    "河北": "HEBEI",
    "山西": "SHANXI_JIN",
    "辽宁": "LIAONING",
    "吉林": "JILIN",
    "黑龙江": "HEILONGJIANG",
    "江西": "JIANGXI",
    "湖南": "HUNAN",
    "四川": "SUCHUAN",
    "贵州": "GUIZHOU",
    "云南": "YUANNAN",
    "内蒙古": "NEIMENGGU",
    "西藏": "XIZANG",
    "外资": "WAIZI",
    "海南": "HAINAN",
    "广州": "GUANGZHOU",
    "深圳": "SHENZHEN",
    "全国": "QUANGUO"
}

//baidu pinyinzhuanyong 2020-11-6
/*
            key为公司宝状态码
*           507: {key: "ACCOUNT_REGISTERED", value: "完成账户注册"},
            508: {key: "MATERIAL_SUBMITTED", value: "完成资料递交"},
            509: {key: "GXB_ACCEPT", value: "⼯信部已受理"},
            510: {key: "GXB_REFUSE", value: "⼯信部不予受理"},
            511: {key: "GXB_FAIL", value: "⼯信部未通过"},
            512: {key: "GXB_SUCCESS", value: "工信部通过"}*/
const baiduIcpStatus = {
    507: "REGISTRATION",
    508: "SUBMITTED",
    509: "ACCEPTED",
    510: "NOT_ACCEPTED",
    511: "APPROVED",
    512: "NOT_APPROVED"
};

/**
 * 资质信息提报相关接口(ICP\EDI)
 */
class BaseCenterOrderService extends AppServiceBase {
    constructor() {
        super();
        this.execClientNew = system.getObject("util.execClientNew");
        this.centerOrderUrl = settings.centerOrderUrl();
        this.execClient = system.getObject("util.execClient");
        this.aliclient = system.getObject("util.aliyunClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
        this.opPushQueueUrl = settings.opPushQueueUrl();
        this.baiduclient = system.getObject("util.baiduClient");
        this.utils360Sve = system.getObject("service.utilsSve.utils360Sve")
    };

    //调用center-order
    async reqCenterOrderApi(pobj, reqUrl) {
        var url = this.centerOrderUrl + "action/qcapi/springBoard";
        if (reqUrl) {
            var url = this.centerOrderUrl + reqUrl;
        }
        var rtn = await this.execClient.execPost(pobj, url);
        var data = JSON.parse(rtn.stdout);
        return data;
    }

    //提交Icp注册方案
    async submitIcpProgramme(pobj) {
        console.log('提交Icp注册方案---', pobj)
        var res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
        if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolution) {
            var needinfo = res.data.needinfo;//需求信息
            var needsolution = res.data.needsolution;//方案信息
            var ab = pobj.actionBody;
            if (typeof (ab.solutionContent) == "string") {
                ab.solutionContent = JSON.parse(ab.solutionContent);
            }
            if (typeof (needsolution.solutionContent) == "string") {
                needsolution.solutionContent = JSON.parse(needsolution.solutionContent);
            }
            var solution = needsolution.solutionContent.solution;
            if (ab.isTest && ab.isTest == 1) {
                var reqPushParams = {
                    actionBody: {
                        uapp_id: needinfo.uapp_id,
                        channelNeedNo: needinfo.channelNeedNo,
                        CompanyName: solution.CompanyName,
                        IcpType: solution.IcpType,
                        CompanyAddress: solution.CompanyAddress,
                        Area: solution.Area,
                        Note: solution.Note,
                        ActionType: solution.ActionType,
                        channelSolutionNo: needsolution.channelSolutionNo,
                        solutionNo: needsolution.solutionNo,
                    },
                    appInfo: pobj.appInfo
                };
                await this.utilsPushSve.business2Channel(reqPushParams, "pushIcpSolution2Channel");
            } else {
                var self = this;
                //2020-10-26 laolan 区分百度与阿里
                if (needinfo.uapp_id == uappId.ali) {
                    //推送数据至阿里
                    // var bizType = needinfo.channelTypeCode;//业务类型里
                    var pushObj = {
                        IntentionBizId: needinfo.channelNeedNo,
                        CompanyName: solution.CompanyName,
                        IcpType: solution.IcpType,
                        CompanyAddress: solution.CompanyAddress,
                        Area: solution.Area,
                        Note: solution.Note,
                        ActionType: solution.ActionType,
                        Source: "官网"
                    };
                    if (needsolution.channelSolutionNo) {
                        pushObj["BizId"] = needsolution.channelSolutionNo;
                    }
                    var pushIcpSolutionRes = await this.pushIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
                }

                if (needinfo.uapp_id == uappId.baidu) {
                    //推送数据至baidu
                    // var bizType = needinfo.channelTypeCode;//业务类型里
                    solution.Area = cityLetter[solution.Area]
                    console.log('solution.Area++', solution.Area)
                    var pushObj = {
                        requirementId: needinfo.channelNeedNo,
                        companyName: solution.CompanyName,
                        companyAddress: solution.CompanyAddress,
                        area: solution.Area,
                        type: solution.IcpType
                    };
                    if (needsolution.channelSolutionNo) {
                        pushObj["bizId"] = needsolution.channelSolutionNo;
                    }
                    console.log('pushObj++', pushObj)
                    var pushIcpSolutionRes = await this.pushBaiduIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
                }
                if (needinfo.uapp_id == uappId.ename) {
                    //推送数据至易名
                    // var bizType = needinfo.channelTypeCode;//业务类型里
                    // solution.Area = cityLetter[solution.Area]
                    console.log('solution.Area++', solution.Area)
                    console.log('solution++', solution)
                    var pushObj = {
                        IntentionBizId: needinfo.channelNeedNo,
                        CompanyName: solution.CompanyName,
                        CompanyAddress: solution.CompanyAddress,
                        Area: solution.Area,
                        IcpType: solution.IcpType
                    };
                    if (needsolution.channelSolutionNo) {
                        pushObj["BizId"] = needsolution.channelSolutionNo;
                    }
                    var pushIcpSolutionRes = await this.pushEnameIcpSolution(pushObj, needsolution.solutionNo, pobj.appInfo, self);
                }
                this.logCtl.info({
                    appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                    appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                    requestId: pobj.requestId || "",
                    op: "service/impl/common/qcCenterOrderSve.js/submitIcpProgramme",
                    content: JSON.stringify(pobj),
                    resultInfo: JSON.stringify(needinfo),
                    optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
                });
            }

            var reqParams = {
                actionBody: {
                    intentionBizId: needinfo.channelNeedNo,
                    status: "createSolution"
                },
                appInfo: pobj.appInfo
            }
            await this.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
        }
        return res;
    }

    //推送ICP方案至渠道方
    async pushIcpSolution2Channel(pobj) {
        var actionBody = pobj.actionBody;
        var appInfo = pobj.appInfo;
        var pushRes = {
            status: -1, msg: "推送失败"
        };
        var self = this;
        if (actionBody) {
            //2020-10-26 laolan 区分百度与阿里
            if (actionBody.uapp_id == uappId.ali) {
                //推送数据至阿里
                var pushObj = {
                    IntentionBizId: actionBody.channelNeedNo,
                    CompanyName: actionBody.CompanyName,
                    IcpType: actionBody.IcpType,
                    CompanyAddress: actionBody.CompanyAddress,
                    Area: actionBody.Area,
                    Note: actionBody.Note,
                    ActionType: actionBody.ActionType,
                    Source: "官网"
                };
                if (actionBody.channelSolutionNo) {
                    pushObj["BizId"] = actionBody.channelSolutionNo;
                }
                pushRes = await this.pushIcpSolution(pushObj, actionBody.solutionNo, pobj.appInfo, self);
            }
            if (actionBody.uapp_id == uappId.baidu) {
                //推送数据至baidu
                actionBody.Area = cityLetter[actionBody.Area];
                var pushObj = {
                    requirementId: actionBody.channelNeedNo,
                    companyName: actionBody.CompanyName,
                    companyAddress: actionBody.CompanyAddress,
                    area: actionBody.Area,
                    type: actionBody.IcpType
                };
                if (actionBody.channelSolutionNo) {
                    pushObj["bizId"] = actionBody.channelSolutionNo;
                }
                pushRes = await this.pushBaiduIcpSolution(pushObj, actionBody.solutionNo, pobj.appInfo, self);
            }
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "app/base/service/impl/common/baseCenterOrderSve.js/pushIcpSolution2Channel",
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(pushRes),
                optitle: "pushIcpSolution2Channel推送ICP方案至渠道方->pushIcpSolution2Channel",
            });
        }
        if (pushRes.status == 0 || pushRes.status == 1) {
            return system.getResultRedisQueueSuccess();
        }
        return pushRes;
    }

    //推送ICP方案ali
    async pushIcpSolution(pushObj, solutionNo, appInfo, self) {
        //推送方案信息
        var pushRes = await self.aliclient.reqbyget({
            action: "SubmitIcpSolution",
            reqbody: pushObj,
            apiVersion: "2019-05-08"
        });
        if (pushRes && pushRes.status == 0 && pushRes.data) {
            var resData = pushRes.data;
            if (resData.BizId) {
                var reqObj2 = {
                    actionType: "receiveProgrammeNo",
                    appInfo: appInfo,
                    actionBody: {
                        solutionNo: solutionNo,
                        solutionBizId: resData.BizId
                    }
                };
                var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
                if (a && a.status == 0) {
                    //推送方案确认信息
                    var confirmRes = await self.aliclient.reqbyget({
                        action: "ConfirmIntention",
                        reqbody: {BizId: pushObj.IntentionBizId},
                        apiVersion: "2019-05-08"
                    });
                    if (confirmRes && confirmRes.status == 0 && confirmRes.data) {
                        var confirmResData = confirmRes.data;
                        if (confirmResData.ConfirmUrl) {
                            var reqObj3 = {
                                actionType: "receiveIcpConfirmUrl",
                                appInfo: appInfo,
                                actionBody: {
                                    solutionNo: solutionNo,
                                    confirmUrl: confirmResData.ConfirmUrl
                                }
                            };
                            var a = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
                        }
                    }
                    // return confirmRes;
                }
            }
        }
        return pushRes;
    }

    //推送ICP方案易名 2021-02-25 庄冰
    async pushEnameIcpSolution(pushObj, solutionNo, appInfo, self) {
        console.log('pushObj++Ename+++', pushObj);
        //推送方案信息
        var rtn = await self.execClient.execEnamePost(pushObj, settings.enameClientUrl() + "SubmitIcpSolution");
        console.log("url+++++", settings.enameClientUrl() + "SubmitIcpSolution")
        console.log("rtn+++++", rtn)
        if (!rtn || !rtn.stdout) {
            return system.getResult(null, "execPost data is empty");
        }
        var pushRes = JSON.parse(rtn.stdout);

        // var pushRes = await self.baiduclient.baiduReqbyget({  path: "/api/bla/provider/plan", reqbody: pushObj });
        console.log("pushRes++++", pushRes)
        if (pushRes && pushRes.ErrorCode == "200" && pushRes.Success == true && pushRes.BizId) {
            var reqObj2 = {
                actionType: "receiveProgrammeNo",
                appInfo: appInfo,
                actionBody: {
                    solutionNo: solutionNo,
                    solutionBizId: pushRes.BizId
                }
            };
            var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
            console.log("保存渠道方案id aaaa++ ", a)
            if (a && a.status == 0 && pushRes.ConfirmUrl) {
                var reqObj3 = {
                    actionType: "receiveIcpConfirmUrl",
                    appInfo: appInfo,
                    actionBody: {
                        solutionNo: solutionNo,
                        confirmUrl: pushRes.ConfirmUrl
                    }
                };
                var url = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
                console.log('save confirmUrl ++ ', url)
            }
        }
        return pushRes;
    }

    //推送ICP方案baidu 2020-10-26 laolan
    async pushBaiduIcpSolution(pushObj, solutionNo, appInfo, self) {
        console.log('pushObj++baidu+++', pushObj)
        //推送方案信息
        var pushRes = await self.baiduclient.baiduReqbyget({path: "/api/bla/provider/plan", reqbody: pushObj});
        console.log("pushRes++++", pushRes)
        if (pushRes && pushRes.status == 0 && pushRes.data) {
            var resData = pushRes.data;
            if (resData.planId) {
                var reqObj2 = {
                    actionType: "receiveProgrammeNo",
                    appInfo: appInfo,
                    actionBody: {
                        solutionNo: solutionNo,
                        solutionBizId: resData.planId
                    }
                };
                var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id
                console.log("保存渠道方案id aaaa++ ", a)
                if (a && a.status == 0 && resData.path) {
                    var reqObj3 = {
                        actionType: "receiveIcpConfirmUrl",
                        appInfo: appInfo,
                        actionBody: {
                            solutionNo: solutionNo,
                            confirmUrl: resData.path
                        }
                    };
                    var url = await self.reqCenterOrderApi(reqObj3);//保存用户确认方案url
                    console.log('save confirmUrl ++ ', url)
                }
            }
        }
        return pushRes;
    }

    //队列推送材料
    async serviceProviderSubmit2Material(pobj) {
        console.log("serviceProviderSubmit2Material+++++pobj+++", pobj)
        var actionBody = pobj.actionBody;
        var appInfo = pobj.appInfo;
        var pushRes = {
            status: -1, msg: "推送失败"
        };
        if (actionBody) {
            if (actionBody.uapp_id == uappId.ali) {
                //推送数据至阿里
                var pushObj = {
                    "BizId": actionBody.BizId,
                    "Domain": actionBody.Domain,
                    "CorporateName": actionBody.CorporateName,
                    "IncludeForeignInvestment": actionBody.IncludeForeignInvestment,
                    "PartnerBusinessLicense": actionBody.PartnerBusinessLicense,
                    "PartnerIdCardList": actionBody.PartnerIdCardList,
                    "PartnerDomainCertificate": actionBody.PartnerDomainCertificate,
                    "PartnerPreviewOtherList": actionBody.PartnerPreviewOtherList || [],
                    "PartnerPlan": actionBody.PartnerPlan || "",
                    "PartnerForeignInvestment": actionBody.PartnerForeignInvestment || "",
                    "PartnerLaw": actionBody.PartnerLaw || "",
                    "PartnerStampOtherList": actionBody.PartnerStampOtherList || [],
                    "PartnerSignOtherList": actionBody.PartnerSignOtherList || [],
                    "PartnerSignAndStampOtherList": actionBody.PartnerSignAndStampOtherList || []
                };
                var self = this;
                //推送方案材料
                var ali = await self.aliclient.reqbyget({
                    action: "SavePartnerSubmitMaterial",
                    reqbody: pushObj,
                    apiVersion: "2019-05-08"
                });
                console.log('ali -----  +++', ali)
                if (ali && ali.status == 200) {
                    var aliFlag = 200
                } else {
                    var aliFlag = -200
                }
            }

            if (actionBody.uapp_id == uappId.baidu) {
                //推送数据至百度
                var pushObj = {
                    "businessLicense": {
                        "address": actionBody.businessLicense.address || "",
                        "businessTerm": actionBody.businessLicense.businessTerm || "",
                        "createdAt": actionBody.businessLicense.createdAt || "",
                        "enterpriseCode": actionBody.businessLicense.enterpriseCode || "",
                        "legalRepresentative": actionBody.businessLicense.legalRepresentative || "",
                        "name": actionBody.businessLicense.name || "",
                        "registeredCapital": actionBody.businessLicense.registeredCapital || "",
                        "scopeBusiness": actionBody.businessLicense.scopeBusiness || "",
                        "type": actionBody.businessLicense.type || ""
                    },
                    "domain": actionBody.domain,
                    "corporateName": actionBody.corporateName,
                    "includeForeignInvestment": actionBody.includeForeignInvestment,
                    "orderNo": actionBody.orderNo,
                    "partnerForeignInvestment": actionBody.partnerForeignInvestment || "",
                    "partnerBusinessLicense": actionBody.partnerBusinessLicense,
                    "partnerIdCardList": actionBody.partnerIdCardList,
                    "partnerDomainCertificate": actionBody.partnerDomainCertificate,
                    "partnerPreviewOtherList": actionBody.partnerPreviewOtherList || [],
                    "partnerPlan": actionBody.partnerPlan || "",
                    "partnerLaw": actionBody.partnerLaw || "",
                    "partnerStampOtherList": actionBody.partnerStampOtherList || [],
                    "partnerSignOtherList": actionBody.partnerSignOtherList || [],
                    "partnerSignAndStampOtherList": actionBody.partnerSignAndStampOtherList || []
                };
                var self = this;
                //推送方案材料
                var baidu = await self.baiduclient.baiduReqbyget({
                    path: "/api/bla/provider/license/material",
                    reqbody: pushObj
                });
                console.log('baidu -----+++++', baidu)
                if (baidu && baidu.data && baidu.data.result) {
                    var baiduFlag = 200
                } else {
                    var baiduFlag = -200
                }
                console.log('hhhhh+++baiduFlag+++', baiduFlag)
            }
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "app/base/service/impl/common/baseCenterOrderSve.js/serviceProviderSubmit2Material",
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(pushRes),
                optitle: "serviceProviderSubmit2Material推送ICP材料至渠道方->serviceProviderSubmit2Material",
            });
        }
        if (aliFlag == 200 || baiduFlag == 200) {
            // pushRes.status = 1
            return system.getResultRedisQueueSuccess();
        }
        return pushRes;
    }

    //交付材料提交
    async serviceProviderSubmitMaterial(pobj) {
        let self = this;
        let resFlag = -200;
        try {
            let res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
            this.execClientNew.execLogs("serviceProviderSubmitMaterial-reqCenterOrderApi:", pobj, "center-channel-serviceProviderSubmitMaterial", res, null);
            if (res && res.status == 0 && res.data) {
                let needsolution = res.data;//方案信息
                let ab = pobj.actionBody;
                if (typeof (ab.material) == "string") {
                    ab.material = JSON.parse(ab.material);
                }
                let material = ab.material;
                let reqPushParams = {};
                if (ab.isTest && ab.isTest == 1) {
                    if (res.data.uapp_id == uappId.ali) {
                        //推送数据至阿里
                        let BizId = needsolution.channelSolutionNo;//⽅案业务ID
                        reqPushParams = {
                            actionBody: {
                                "uapp_id": res.data.uapp_id,
                                "BizId": BizId,
                                "Domain": material.Domain,
                                "CorporateName": material.CorporateName,
                                "IncludeForeignInvestment": material.IncludeForeignInvestment,
                                "PartnerBusinessLicense": material.PartnerBusinessLicense,
                                "PartnerIdCardList": material.PartnerIdCardList,
                                "PartnerDomainCertificate": material.PartnerDomainCertificate,
                                "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                                "PartnerPlan": material.PartnerPlan || "",
                                "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
                                "PartnerLaw": material.PartnerLaw || "",
                                "PartnerStampOtherList": material.PartnerStampOtherList || [],
                                "PartnerSignOtherList": material.PartnerSignOtherList || [],
                                "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
                            },
                            appInfo: pobj.appInfo
                        };
                    }
                    if (res.data.uapp_id == uappId.baidu) {
                        //推送数据至百度
                        let BizId = needsolution.orderChannelNo;
                        reqPushParams = {
                            actionBody: {
                                "uapp_id": res.data.uapp_id,
                                "businessLicense": {
                                    "address": material.BusinessLicense.Address || "",
                                    "businessTerm": material.BusinessLicense.BusinessTerm || "",
                                    "createdAt": material.BusinessLicense.CreatedAt || "",
                                    "enterpriseCode": material.BusinessLicense.EnterpriseCode || "",
                                    "legalRepresentative": material.BusinessLicense.LegalRepresentative || "",
                                    "name": material.BusinessLicense.Name || "",
                                    "registeredCapital": material.BusinessLicense.RegisteredCapital || "",
                                    "scopeBusiness": material.BusinessLicense.ScopeBusiness || "",
                                    "type": material.BusinessLicense.Type || ""
                                },
                                "corporateName": material.CorporateName,
                                "domain": material.Domain,
                                "includeForeignInvestment": material.IncludeForeignInvestment,
                                "orderNo": BizId,
                                "partnerForeignInvestment": material.PartnerForeignInvestment || "",
                                "partnerBusinessLicense": material.PartnerBusinessLicense,
                                "partnerIdCardList": material.PartnerIdCardList,
                                "partnerDomainCertificate": material.PartnerDomainCertificate,
                                "partnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                                "partnerPlan": material.PartnerPlan || "",
                                "partnerLaw": material.PartnerLaw || "",
                                "partnerStampOtherList": material.PartnerStampOtherList || [],
                                "partnerSignOtherList": material.PartnerSignOtherList || [],
                                "partnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
                            },
                            appInfo: pobj.appInfo
                        }
                    }
                    await this.utilsPushSve.business2Channel(reqPushParams, "serviceProviderSubmit2Material");
                } else {
                    if (res.data.uapp_id == uappId.ali) {
                        //推送数据至阿里
                        let BizId = needsolution.channelSolutionNo;//⽅案业务ID
                        let pushObj = {
                            "CompanyName": material.CompanyName,
                            "BizId": BizId,
                            "Domain": material.Domain,
                            "CorporateName": material.CorporateName,
                            "IncludeForeignInvestment": material.IncludeForeignInvestment,
                            "PartnerBusinessLicense": material.PartnerBusinessLicense,
                            "PartnerIdCardList": material.PartnerIdCardList,
                            "PartnerDomainCertificate": material.PartnerDomainCertificate,
                            "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                            "PartnerPlan": material.PartnerPlan || "",
                            "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
                            "PartnerLaw": material.PartnerLaw || "",
                            "PartnerStampOtherList": material.PartnerStampOtherList || [],
                            "PartnerSignOtherList": material.PartnerSignOtherList || [],
                            "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
                        };

                        //推送方案材料
                        let aliParams = {
                            action: "SavePartnerSubmitMaterial",
                            reqbody: pushObj,
                            apiVersion: "2019-05-08"
                        }
                        let ali = await self.aliclient.reqbyget(aliParams);
                        this.execClientNew.execLogs("serviceProviderSubmitMaterial-aliclient:", aliParams, "center-channel-serviceProviderSubmitMaterial", ali, null);
                        if (ali && ali.status == 200) {
                            resFlag = 200
                        }
                    }

                    if (res.data.uapp_id == uappId.baidu) {
                        //推送数据至百度
                        let BizId = needsolution.orderChannelNo;
                        let pushObj = {
                            "businessLicense": {
                                "createdAt": material.BusinessLicense.CreatedAt || "",
                                "enterpriseCode": material.BusinessLicense.EnterpriseCode || "",
                                "legalRepresentative": material.BusinessLicense.LegalRepresentative || "",
                                "address": material.BusinessLicense.Address || "",
                                "registeredCapital": material.BusinessLicense.RegisteredCapital || "",
                                "name": material.BusinessLicense.Name || "",
                                "businessTerm": material.BusinessLicense.BusinessTerm || "",
                                "type": material.BusinessLicense.Type || "",
                                "scopeBusiness": material.BusinessLicense.ScopeBusiness || ""
                            },
                            "partnerForeignInvestment": material.PartnerForeignInvestment || "",
                            "orderNo": BizId,
                            "domain": material.Domain,
                            "corporateName": material.CorporateName,
                            "includeForeignInvestment": material.IncludeForeignInvestment,
                            "partnerBusinessLicense": material.PartnerBusinessLicense,
                            "partnerIdCardList": material.PartnerIdCardList,
                            "partnerDomainCertificate": material.PartnerDomainCertificate,
                            "partnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                            "partnerPlan": material.PartnerPlan || "",
                            "partnerLaw": material.PartnerLaw || "",
                            "partnerStampOtherList": material.PartnerStampOtherList || [],
                            "partnerSignOtherList": material.PartnerSignOtherList || [],
                            "partnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
                        };
                        //推送方案材料
                        let baiduParams = {path: "/api/bla/provider/license/material", reqbody: pushObj}
                        let baidu = await self.baiduclient.baiduReqbyget(baiduParams);
                        this.execClientNew.execLogs("serviceProviderSubmitMaterial-baiduReqbyget:", baiduParams, "center-channel-serviceProviderSubmitMaterial", baidu, null);
                        if (baidu && baidu.data && baidu.data.result) {
                            resFlag = 200
                        }
                    }

                    if (res.data.uapp_id == uappId.ename) {
                        //推送数据至易名
                        let BizId = needsolution.channelSolutionNo;//⽅案业务ID
                        let pushObj = {
                            "CompanyName": material.CompanyName,
                            // "BizId": BizId,
                            "OrderNo": BizId,
                            "Domain": material.Domain,
                            "CorporateName": material.CorporateName,
                            "IncludeForeignInvestment": material.IncludeForeignInvestment,
                            "PartnerBusinessLicense": material.PartnerBusinessLicense,
                            "PartnerIdCardList": material.PartnerIdCardList,
                            "PartnerDomainCertificate": material.PartnerDomainCertificate,
                            "PartnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                            "PartnerPlan": material.PartnerPlan || "",
                            "PartnerForeignInvestment": material.PartnerForeignInvestment || "",
                            "PartnerLaw": material.PartnerLaw || "",
                            "PartnerStampOtherList": material.PartnerStampOtherList || [],
                            "PartnerSignOtherList": material.PartnerSignOtherList || [],
                            "PartnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || [],
                            "BusinessLicense": {
                                "CreatedAt": material.BusinessLicense.CreatedAt || "",
                                "EnterpriseCode": material.BusinessLicense.EnterpriseCode || "",
                                "LegalRepresentative": material.BusinessLicense.LegalRepresentative || "",
                                "Address": material.BusinessLicense.Address || "",
                                "RegisteredCapital": material.BusinessLicense.RegisteredCapital || "",
                                "Name": material.BusinessLicense.Name || "",
                                "BusinessTerm": material.BusinessLicense.BusinessTerm || "",
                                "Type": material.BusinessLicense.Type || "",
                                "ScopeBusiness": material.BusinessLicense.ScopeBusiness || ""
                            },
                        };
                        //推送方案材料
                        let eNameUrl = settings.enameClientUrl() + "SavePartnerSubmitMaterial";
                        let rtn = await self.execClient.execEnamePost(pushObj, eNameUrl);
                        this.execClientNew.execLogs("serviceProviderSubmitMaterial-execEnamePost:eNameUrl：" + eNameUrl, pushObj, "center-channel-serviceProviderSubmitMaterial", rtn, null);
                        if (rtn && rtn.stdout) {
                            let pushRes = JSON.parse(rtn.stdout);
                            if (pushRes && pushRes.Success && pushRes.Success == true) {
                                resFlag = 200;
                            }
                        }
                    }
                    if (resFlag == 200) {
                        return system.getResultSuccess();
                    }
                }
            }
            return res
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs("serviceProviderSubmitMaterial-reqError:", pobj, "center-channel-serviceProviderSubmitMaterial", null, stackStr);
        }
    }


    //队列通知交付状态变更
    async serviceProvider2Notification(pobj) {
        console.log("serviceProvider2Notification+++++pobj+++", pobj)
        var actionBody = pobj.actionBody;
        var appInfo = pobj.appInfo;
        var pushRes = {
            status: -1, msg: "推送失败"
        };
        if (actionBody) {
            if (actionBody.uapp_id == uappId.ali) {
                //推送数据至阿里
                var pushObj = {
                    BizId: actionBody.BizId,
                    OfficialFileURL: actionBody.OfficialFileURL,
                    ApplicationStatus: actionBody.ApplicationStatus
                };
                //推送状态变更
                var ali = await this.aliclient.reqbyget({
                    action: "AcceptPartnerNotification",
                    reqbody: pushObj,
                    apiVersion: "2019-05-08"
                });
                console.log('状态变更 ali -----  +++', ali)
                if (ali && ali.status == 200) {
                    var aliFlag = 200
                } else {
                    var aliFlag = -200
                }
            }
            if (actionBody.uapp_id == uappId.baidu) {
                // actionBody.ApplicationStatus = baiduIcpStatus[actionBody.ApplicationStatus];
                //推送数据至百度
                var pushObj = {
                    orderNo: actionBody.orderNo,
                    status: actionBody.status
                };
                console.log('pushObj 推送状态变更 +++++', pushObj)
                //推送状态变更
                var baidu = await this.baiduclient.baiduReqbyget({
                    path: "/api/bla/provider/license/update",
                    reqbody: pushObj
                });
                console.log('baidu 推送状态变更 +++++', baidu)
                if (baidu && baidu.data && baidu.data.result) {
                    var baiduFlag = 200
                } else {
                    var baiduFlag = -200
                }
            }
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "app/base/service/impl/common/baseCenterOrderSve.js/serviceProvider2Notification",
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(pushRes),
                optitle: "serviceProvider2Notification推送ICP材料至渠道方->serviceProvider2Notification",
            });
        }
        if (aliFlag == 200 || baiduFlag == 200) {
            pushRes.status = 1
            return system.getResultRedisQueueSuccess();
        }
        return pushRes;
    }

    //通知交付状态变更-所有渠道状态更改
    async serviceProviderNotification(pobj) {
        let self = this;
        let resFlag = -200;
        try {
            let res = await this.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
            this.execClientNew.execLogs("serviceProviderNotification-reqCenterOrderApi:", pobj, "center-channel-serviceProviderNotification", res, null);
            if (res && res.status == 0 && res.data) {
                if (pobj.actionBody.isTest && pobj.actionBody.isTest == 1) {
                    var reqPushParams = {};
                    if (res.data.uapp_id == uappId.ali) {
                        //推送数据至阿里
                        reqPushParams = {
                            actionBody: {
                                uapp_id: res.data.uapp_id,
                                BizId: res.data.BizId,
                                OfficialFileURL: res.data.OfficialFileURL,
                                ApplicationStatus: res.data.ApplicationStatus
                            },
                            appInfo: pobj.appInfo
                        }
                    }
                    if (res.data.uapp_id == uappId.baidu) {
                        res.data.ApplicationStatus = baiduIcpStatus[res.data.ApplicationStatus];
                        //推送数据至百度
                        reqPushParams = {
                            actionBody: {
                                uapp_id: res.data.uapp_id,
                                orderNo: res.data.channelOrderNo,
                                status: res.data.ApplicationStatus
                            },
                            appInfo: pobj.appInfo
                        }
                    }
                    await this.utilsPushSve.business2Channel(reqPushParams, "serviceProvider2Notification");
                } else {

                    if (res.data.uapp_id == uappId.ali) {
                        //推送数据至阿里
                        let pushObj = {
                            BizId: res.data.BizId,
                            OfficialFileURL: res.data.OfficialFileURL,
                            ApplicationStatus: res.data.ApplicationStatus,
                            //2021-3-18 addNew
                            CertificateNumber: res.data.CertificateNumber || "",//证书编号
                            CertificateStartTime: res.data.CertificateStartTime || "",//证书有效期 开始时间
                            CertificateEndTime: res.data.CertificateEndTime || ""//证书有效期 结束时间
                        };
                        //推送状态变更
                        let aliParams = {
                            action: "AcceptPartnerNotification",
                            reqbody: pushObj,
                            apiVersion: "2019-05-08"
                        }
                        let ali = await this.aliclient.reqbyget(aliParams);
                        this.execClientNew.execLogs("serviceProviderNotification-aliclient:", aliParams, "center-channel-serviceProviderNotification", ali, null);
                        if (ali && ali.status == 200) {
                            resFlag = 200
                        }
                    }

                    if (res.data.uapp_id == uappId.ename) {
                        //推送数据至易名
                        let pushObj = {
                            OrderNo: res.data.channelOrderNo,
                            OfficialFileURL: res.data.OfficialFileURL,
                            ApplicationStatus: res.data.ApplicationStatus
                        };
                        let eNameUrl = settings.enameClientUrl() + "AcceptPartnerNotification";
                        let rtn = await self.execClient.execEnamePost(pushObj, eNameUrl);
                        this.execClientNew.execLogs("serviceProviderNotification-execEnamePost:eNameUrl：" + eNameUrl, pushObj, "center-channel-serviceProviderNotification", rtn, null);
                        if (rtn && rtn.stdout) {
                            let pushRes = JSON.parse(rtn.stdout);
                            if (pushRes && pushRes.Success && pushRes.Success == true) {
                                resFlag = 200;
                            }
                        }
                    }

                    if (res.data.uapp_id == uappId.zc360) {
                        pobj.pushObj = res.data;
                        let zc360 = await this.utils360Sve.pushOrderStatus(pobj);
                        if (zc360 && zc360.code == 200 && zc360.msg == 'ok') {
                            resFlag = 200
                        }
                    }

                    if (res.data.uapp_id == uappId.baidu) {
                        res.data.ApplicationStatus = baiduIcpStatus[res.data.ApplicationStatus];
                        //推送数据至百度
                        let tmpMaterial = res.data.material;
                        let pushObj = {
                            orderNo: res.data.channelOrderNo,
                            status: res.data.ApplicationStatus,
                            companyName: tmpMaterial.companyName || "",
                            applyMaterial: tmpMaterial.applyMaterial || "",
                            user: tmpMaterial.user && tmpMaterial.user!= "" ? tmpMaterial.user: null,
                            acceptNotifyFile: tmpMaterial.acceptNotifyFile || "",
                            certificateFile: tmpMaterial.certificateFile || "",
                            expressNum: tmpMaterial.expressNum || ""
                        };
                        //推送状态变更及材料
                        let baiduParams = {
                            path: "/api/bla/provider/license-data",
                            reqbody: pushObj
                        }
                        console.log("baiduReqbyget.......................params....", JSON.stringify(baiduParams))
                        let baidu = await this.baiduclient.baiduReqbyget(baiduParams);
                        console.log("baiduReqbyget.......................baiduRes....", JSON.stringify(baidu))
                        this.execClientNew.execLogs("serviceProviderNotification-updateStatus-baiduReqbyget:", baiduParams, "center-channel-serviceProviderNotification", baidu, null);
                        if (baidu && baidu.data && baidu.data.result) {
                            resFlag = 200
                        }

                        // let pushObj = {
                        //     orderNo: res.data.channelOrderNo,
                        //     status: res.data.ApplicationStatus
                        // };
                        // //推送状态变更
                        // let baiduParams = {
                        //     path: "/api/bla/provider/license/update",
                        //     reqbody: pushObj
                        // }
                        // let baidu = await this.baiduclient.baiduReqbyget(baiduParams);
                        // this.execClientNew.execLogs("serviceProviderNotification-updateStatus-baiduReqbyget:", baiduParams, "center-channel-serviceProviderNotification", baidu, null);
                        // if (baidu && baidu.data && baidu.data.result) {
                        //     resFlag = 200
                        // }

                        // //推送材料数据至百度用于更新订单状态完成
                        // let material = res.data.material;
                        // if (material) {
                        //     let pushMaterialObj = {
                        //         "businessLicense": {
                        //             "createdAt": material.BusinessLicense.CreatedAt || "",
                        //             "enterpriseCode": material.BusinessLicense.EnterpriseCode || "",
                        //             "legalRepresentative": material.BusinessLicense.LegalRepresentative || "",
                        //             "address": material.BusinessLicense.Address || "",
                        //             "registeredCapital": material.BusinessLicense.RegisteredCapital || "",
                        //             "name": material.BusinessLicense.Name || "",
                        //             "businessTerm": material.BusinessLicense.BusinessTerm || "",
                        //             "type": material.BusinessLicense.Type || "",
                        //             "scopeBusiness": material.BusinessLicense.ScopeBusiness || ""
                        //         },
                        //         "partnerForeignInvestment": material.PartnerForeignInvestment || "",
                        //         "orderNo": res.data.channelOrderNo,
                        //         "domain": material.Domain,
                        //         "corporateName": material.CorporateName,
                        //         "includeForeignInvestment": material.IncludeForeignInvestment,
                        //         "partnerBusinessLicense": material.PartnerBusinessLicense,
                        //         "partnerIdCardList": material.PartnerIdCardList,
                        //         "partnerDomainCertificate": material.PartnerDomainCertificate,
                        //         "partnerPreviewOtherList": material.PartnerPreviewOtherList || [],
                        //         "partnerPlan": material.PartnerPlan || "",
                        //         "partnerLaw": material.PartnerLaw || "",
                        //         "partnerStampOtherList": material.PartnerStampOtherList || [],
                        //         "partnerSignOtherList": material.PartnerSignOtherList || [],
                        //         "partnerSignAndStampOtherList": material.PartnerSignAndStampOtherList || []
                        //     };
                        //     //推送方案材料
                        //     let baiduMaterialParams = {
                        //         path: "/api/bla/provider/license/material",
                        //         reqbody: pushMaterialObj
                        //     }
                        //     let baiduMaterial = await self.baiduclient.baiduReqbyget(baiduMaterialParams);
                        //     this.execClientNew.execLogs("serviceProviderNotification-updateMaterial-baiduReqbyget:", pushMaterialObj, "center-channel-serviceProviderNotification", baiduMaterial, null);
                        // }
                    }


                    if (resFlag == 200) {
                        return system.getResultSuccess();
                    }
                }
            }
            return res;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs("serviceProviderNotification-reqError:", pobj, "center-channel-serviceProviderNotification", null, stackStr);
        }
    }


    //易名退款，关闭订单 2021-3-23
    async eNameCloseOrder(pobj) {
        console.log("eNameCloseOrder+++", pobj)
        var pushObj = {}
        var orderNo
        var note
        orderNo = pobj.actionBody.orderNo
        note = pobj.actionBody.note
        pobj.actionType = "delENameOrder"
        var res = await this.utilsOrderSve.delENameOrder(pobj, pobj.actionBody);
        if (res.status < 0) {
            return system.getResultFail(-5022, "订单关闭失败");
        }
        console.log('delOrder---', res)
        if (res && res.status == 0 && res.data && res.data.channelOrderNo) {
            pushObj = {
                OrderNo: res.data.channelOrderNo,
                Note: note
            }
            console.log('eNameCloseOrder+++pushObj----', pushObj)
            var rtn = await this.execClient.execEnamePost(pushObj, settings.enameClientUrl() + "CloseOrder");
            console.log('eNameCloseOrder+++rtn----', rtn)
            if (rtn && rtn.stdout) {
                var pushRes = JSON.parse(rtn.stdout);
                if (pushRes && pushRes.Success && pushRes.Success == true) {
                    console.log('ename----', pushRes)
                    return pushRes
                }
            }
        }
        return res
    }
}

module.exports = BaseCenterOrderService;