const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

class IcbcService extends AppServiceBase {
    constructor() {
            super();
            this.zcApiUrl = settings.reqZcApi();
            this.certificationUrl = settings.certificationUrl();
            this.restClient = system.getObject("util.redisClient");
            //处理企业资质证书数据
            this.disposeCertificationData = "disposeCertificationData";
            //企业资质证书查询
            this.searchCertificationData = "searchCertificationData";
            //result工具类
            this.utilsResultSve = system.getObject("service.utilsSve.utilsResultSve");
        }
        //企业模糊查询
    async getCompanyListByVague(obj, req) {
            var url = this.zcApiUrl + "api/tool/toolApi/getCompanyListByVague";
            return await this.opReqResult(url, obj, req);
        }
        //企业详情
    async getDetailByCompanyName(queryobj, req) {
            var url = this.zcApiUrl + "api/tool/toolApi/getDetailByCompanyName";
            return await this.opReqResult(url, queryobj, req);
        }
        //企业变更记录查询
    async getCompanyChangeByName(queryobj, req) {
            var url = this.zcApiUrl + "api/tool/toolApi/getCompanyChangeByName";
            return await this.opReqResult(url, queryobj, req);
        }
        //工商icp证照查询
    async getCompanyIcpByName(queryobj, req) {
        var url = this.zcApiUrl + "api/tool/toolApi/getCompanyIcpByName";
        return await this.opReqResult(url, queryobj, req);
    }

    //企业证书查询
    // async searchCertification(queryobj, req) {
    //   if (!queryobj.companyName) {
    //     return system.getResultFail(-1, 'companyName can not be empty');
    //   }
    //   var hashValue = await this.restClient.hget(this.searchCertificationData, queryobj.companyName);
    //   if (hashValue) {
    //     return system.getResultSuccess(JSON.parse(hashValue));
    //   }
    //   let url = this.certificationUrl + "gsb/SearchCertification";
    //   let data = {
    //     "company_name": queryobj.companyName,
    //     "pageSize": 20,
    //     "pageIndex": 1,
    //     "isExactlySame": "True"
    //   }
    //   let result = await this.opReqResult(url, data, req);
    //   if (!result) {
    //     return system.getResultFail(-1, '查询失败！！！');
    //   }
    //   if (result.Status != 200) {
    //     return system.getResultFail(-1, '查询失败');
    //   }
    //   //对结果处理
    //   // "Tag": 1为qichacha,0为gsb
    //   var setValue = {};
    //   setValue[queryobj.companyName] = JSON.stringify(result.Result);
    //   if (result.Tag == 1) {
    //     this.restClient.hmset(this.disposeCertificationData, setValue);
    //   }
    //   this.restClient.hmset(this.searchCertificationData, setValue);
    //   return system.getResult(result.Result);
    // }

    //企业证书查询 用友数据源
    async searchCertification(queryobj, req) {
        if (!queryobj.companyName) {
            return system.getResultFail(-1, 'companyName can not be empty');
        }
        var hashValue = await this.restClient.hget(this.searchCertificationData, queryobj.companyName);
        if (hashValue) {
            return system.getResultSuccess(JSON.parse(hashValue));
        }
        //获取token
        let url = settings.icNameUrl() + 'openPlatform/platform/getToken';
        let params = settings.openPlatformAK();
        req.headers.token='sss'
        let ret = await this.opReqResult(url, params, req);
        if (ret.status != 1) {
            return system.getResultFail(-1, '获取开放平台token失败');
        }
        let token = ret.data;

        url = settings.icNameUrl() + "openPlatform/busenterprise/cloudapi";
        //资质查询
        let data = {
            // "path": "/apis/dst/patents/getLicense",
            "path": "/apis/dst/patents/certificate",
            "name": queryobj.companyName,
            "pageNum":1
        };
        let rtn = await this.execClient.restGetWithHAuthorizationUrl(token, url, data);
        if (!rtn || !rtn.stdout) {
            return system.getResult(null, "restPostWithHAuthorizationUrl data is empty");
        };
        var result = JSON.parse(rtn.stdout);
        if (!result) {
            return system.getResultFail(-1, '查询失败！！！');
        }
        if (result.error_code != 0) {
            return system.getResultFail(-1, '查询失败');
        }
        let item = result.result.items;
        //对结果处理
        // "Tag": 1为qichacha,0为gsb
        var setValue = {};
        setValue[queryobj.companyName] = JSON.stringify(item);
        // if (result.Tag == 1) {
        //   this.restClient.hmset(this.disposeCertificationData, setValue);
        // }
        this.restClient.hmset(this.searchCertificationData, setValue);
        return system.getResult(item);
    }


    /**
     * 获取资质证书（集合）
     * @param obj
     * @param req
     * @returns {Promise<void>}
     */
    async getLicenseList(obj,req){
        let companyName = obj.companyName;
        let url = settings.icNameUrl() + 'platform/getToken';
        let params = settings.openPlatformAK();
        req.headers.token='sss'
        let ret = await this.opReqResult(url, params, req);
        if (ret.status != 1) {
            return system.getResultFail(-1, '获取开放平台token失败');
        }
        let token = ret.data;
        let url2 = settings.icNameUrl() + "busenterprise/cloudapi";
        let params1 = {
            "path": "/apis/dst/patents/certificate",
            "name": companyName,
            "pageNum":1
        }
        let params2 = {
            "path": "/apis/dst/patents/getLicense",
            "name": companyName,
            "pageNum":1
        }
        let params3 = {
            "companyName":companyName
        }
        let funcs = [];
        funcs.push(this.execClient.restGetWithHAuthorizationUrl(token, url2, params1));
        funcs.push(this.execClient.restGetWithHAuthorizationUrl(token, url2, params2));
        funcs.push(this.getCompanyIcpByName(params3,req));
        let results = await Promise.all(funcs);
        if(results.length==0){
            return system.getResultFail(-1,'查询失败，请稍后再试');
        }
        let ret1 = JSON.parse(results[0].stdout);
        let ret2 = JSON.parse(results[1].stdout);
        let ret3 = results[2];
        let resultData = [];
        if(ret1.error_code == 0 && ret1.result.items.length >0){
            for(let i =0;i<ret1.result.items.length;i++){
                let d = ret1.result.items[i];
                let obj = {
                    licencenumber:d.certNo,
                    licencename:d.certificateName,
                    startDate:d.startDate,
                    endDate:d.endDate,
                    detail:d.detail
                };
                resultData.push(obj);
            }
        }
        if(ret2.error_code == 0 && ret2.result.items.length >0){
            for(let i =0;i<ret2.result.items.length;i++){
                let d = ret2.result.items[i];
                let obj = {
                    licencenumber:d.licencenumber,
                    licencename:d.licencename,
                    startDate:d.fromdate,
                    endDate:d.todate,
                    detail:d.detail
                };
                if(!resultData.includes(obj)){
                    resultData.push(obj);
                }
            }
        }
        if(ret3.status == 0 && ret3.data.list.length>0){
            for(let i =0;i<ret3.data.list.length;i++){
                let d = ret3.data.list[i];
                let obj = {
                    licencenumber:d.liscense,
                    licencename:"icp备案",
                    examine_date:d.examine_date
                };
                resultData.push(obj);
            }
        }
        return system.getResultSuccess(resultData);
    }





    async opReqResult(reqUrl, queryobj, req) {
        var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"], req.headers["request-id"]);
        var data = JSON.parse(rtn.stdout);
        return data;
    }
}
module.exports = IcbcService;