var system = require("../../../system");
const AppServiceBase = require("../../app.base");
//外部请求结果校验以及相应工具处理类
class utilsTlBankSve extends AppServiceBase {
    constructor() {
        super();
    }

    //格式化时间
    convertDate(time) {
        if (time == null) {
            return "";
        }
        var date = new Date(Number(time * 1000));
        var y = 1900 + date.getYear();
        var m = "0" + (date.getMonth() + 1);
        var d = "0" + date.getDate();
        return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
    }

    //计算并返回指定字段
    formulaContinued(tms) {
        let result = [];

        for (let i = 0; i < tms.length; i++) {
            let tmInfo = tms[i];
            let tm_expiry = '';
            if (!tmInfo.MARKNAME) { //REGDATE注册公告日期
                continue;
            }
            if (tmInfo.REGDATE) {
                let zcrqFormat = new Date(tmInfo.REGDATE * 1000); //注册日期
                zcrqFormat.setFullYear(zcrqFormat.getFullYear() + 10); //专用起始日期计算
                zcrqFormat.setMonth(zcrqFormat.getMonth()); //专用起始日期计算
                zcrqFormat.setDate(zcrqFormat.getDate()); //专用起始日期计算
                tm_expiry = this.convertDate(zcrqFormat); //计算商标到期日
            }

            let tmObject = {
                "tm_comName": tmInfo.AGENTNAME, //代理机构
                "tm_img": tmInfo.MARKIMAGE, //商标图片
                "tm_name": tmInfo.MARKNAME, //商标名称
                "tm_appDate": tmInfo.APPDATE, //申请日期
                "tm_isInvalid": tmInfo.ISINVALID, //状态
                "tm_expiry": tm_expiry //商标到期日
            }
            result.push(tmObject);
        }
        return result;
    }

}
module.exports = utilsTlBankSve;