const childproc = require('child_process');
const system = require("../system");
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const settings = require("../../../app/config/settings");
const axios = require('axios');
const moment = require('moment');
const uuid = require('uuid');

class ExecClientNew {
    constructor() {
        this.cmdGetPattern = "curl -G -X GET '{url}'";
        this.cmdPostPattern = "curl -k -H 'Content-type: application/json' -d '{data}' {url}";
        // this.cmdPushDataPostPattern = "curl -k -H 'Content-type: application/json' -H 'token:{tk}' -H 'appkey:{appkey}' -d '{data}' {url}";        
    }

    /**
     * 带超时时间的post请求
     * @param {*} execFile 执行文件
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间设置，单位秒
     * @param {*} req 请求信息
     */
    async execPostTimeOutByBusiness(execFile, params, url, ContentType, headData, timeOut = 60, req) {
        var rtn = null;
        var reqResult = null;
        var requestId = null;
        if (req && req.body && (req.body.RequestId || req.body.requestId)) {
            requestId = req.body.RequestId || req.body.requestId;
        } else {
            if (req && req.query && (req.query.RequestId || req.query.requestId)) {
                requestId = req.query.RequestId || req.query.requestId;
            }
        }
        try {
            if (settings.env === "localhost" || settings.env === "dev") {
                var headers = {
                    'Content-type': 'application/json'
                }
                if (headData) {
                    var headDataKeys = Object.keys(headData);
                    if (headDataKeys.length > 0) {
                        for (let index = 0; index < headDataKeys.length; index++) {
                            const indexKey = headDataKeys[index];
                            var headValue = headData[indexKey];
                            if (indexKey && headValue) {
                                headers[indexKey] = headValue;
                            }
                        }
                    }
                }
                axios.default.timeout = timeOut;
                let result = await axios({
                    // headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    headers: headers,
                    method: 'POST',
                    url: url,
                    data: JSON.stringify(params)
                });
                if (result.status == 200) {
                    reqResult = system.getResultSuccess(result.data);

                } else {
                    reqResult = system.getResult(null, "执行execPostTimeOutByBusiness存在错误");
                }
                reqResult.requestId = requestId || uuid.v1();
                if (result.headers) {
                    delete result["headers"];
                }
                if (result.request) {
                    delete result["request"];
                }
                if (result.config) {
                    delete result["config"];
                }
                params.reqUrl = url;
                this.execLogs(execFile + "执行execPostTimeOutByBusiness，errorInfo信息为请求的返回结果", params, params.identifyCode, reqResult, result);
                return reqResult;
            }
            //方式二
            rtn = await this.execPostTimeOut(params, url, ContentType, headData, timeOut);
            params.reqUrl = url;
            if (!rtn || !rtn.stdout) {
                this.execLogs(execFile + "执行execPostTimeOutByBusiness返回的数据为空", params, params.identifyCode, null, null);
                reqResult = system.getResult(null, "execPostTimeOut data is empty");
            } else {
                var result = JSON.parse(rtn.stdout);
                reqResult = system.getResultSuccess(result);
            }
            reqResult.requestId = requestId || uuid.v1();
            this.execLogs(execFile + "执行execPostTimeOutByBusiness，errorInfo信息为请求的返回结果", params, params.identifyCode, reqResult, rtn);
            return reqResult;
        } catch (error) {
            console.log("执行execPostByTimeOut存在异常", error.stack);
            reqResult = system.getResultFail(-200, execFile + "执行execPostByTimeOut存在异常");
            reqResult.requestId = requestId || uuid.v1();
            this.execLogs(execFile + "执行execPostByTimeOut存在异常", params, params.identifyCode, reqResult, error.stack);
            return reqResult;
        }
    }

    /**
     * 记录日志信息
     * @param {*} opTitle 操作的标题
     * @param {*} params 参数
     * @param {*} identifyCode 业务标识
     * @param {*} resultInfo 返回结果
     * @param {*} errorInfo 错误信息
     */
    async execLogs(opTitle, params, identifyCode, resultInfo, errorInfo) {
        var reqUrl = settings.opNewLogUrl();
        let tmpParams1 = typeof params === 'object' ? JSON.stringify(params) : params || "";
        let tmpResultInfo = typeof resultInfo === 'object' ? JSON.stringify(resultInfo) : resultInfo || "";
        let tmpErrorInfo = typeof errorInfo === 'object' ? JSON.stringify(errorInfo) : errorInfo || "";
        var tmpParams = {
            opTitle: opTitle || "",
            identifyCode: identifyCode || "",
            messageBody: tmpParams1,
            resultInfo: tmpResultInfo || "",
            errorInfo: tmpErrorInfo || "",
            requestId: resultInfo ? resultInfo.requestId || "" : "",
            created_at: moment().format("YYYY-MM-DD HH:mm:ss:SSS"),
            timestamp: Date.now()
        }
        this.execPostTimeOut(tmpParams, reqUrl, 'application/json', null, 20);
    }

    /**
     * get请求
     * @param {*} params 提交的数据-格式JSON
     * @param {*} url
     * @param {*} headData  请求信息，JSON格式
     */
    async execGet(params, url, headData) {
        let cmd = this.FetchGetCmd(params, url, headData);
        var result = await this.exec(cmd);
        return result;
    }

    /**
     *
     * @param {*} params 提交的数据JSON格式
     * @param {*} url
     * @param {*} headData  请求信息，JSON格式
     * @param {*} timeOut 超时时间
     */
    async execGetTimeOut(params, url, headData, timeOut = 5000) {
        //timeOut，单位是毫秒
        let cmd = this.FetchGetCmd(params, url, headData);
        var options = {
            timeout: timeOut,
        };
        const {stdout, stderr} = await exec(cmd, options);
        return {stdout, stderr};
    }

    /**
     * 带超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     */
    async execPost(params, url, ContentType, headData, timeOut = 5000) {
        if (!ContentType) {
            ContentType = "application/json";
        }
        let cmd = this.FetchPostCmd(params, url, ContentType, headData);
        var options = {
            timeout: timeOut,
            maxBuffer: 1024 * 1024 * 15
        };
        var result = await this.exec(cmd, options, headData);
        return result;
    }

    /**
     * 带超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间设置，单位秒
     */
    async execPostTimeOut(params, url, ContentType, headData, timeOut = 5000) {
        if (!ContentType) {
            ContentType = "application/json";
        }
        let cmd = this.FetchPostCmd(params, url, ContentType, headData);
        var options = {
            timeout: timeOut,
            maxBuffer: 1024 * 1024 * 15
        };
        var result = await this.exec(cmd, options);
        return result;
    }

    //--------------------------------------------------辅助方法start-----------------

    async exec(cmd) {
        //await后面表达式返回的promise对象，是then的语法糖，await返回then函数的返回值
        //异常需要try/catch自己捕获或外部catch捕获
        const {stdout, stderr} = await exec(cmd);
        return {stdout, stderr};
    }

    FetchGetCmd(params, url, headData) {
        var cmd = this.cmdGetPattern.replace(
            /\{data\}/g, params).replace(/\{url\}/g, url);
        return cmd;
    }

    FetchPostCmd(params, url, ContentType, headData) {
        if (!ContentType) {
            ContentType = "application/json";
        }
        var data = JSON.stringify(params);
        // if (typeof params === 'object') {
        //     // 声明cache变量，便于匹配是否有循环引用的情况
        //     var cache = [];
        //     data = JSON.stringify(params, function (key, value) {
        //         if (typeof value === 'object' && value !== null) {
        //             if (cache.indexOf(value) !== -1) {
        //                 // 移除
        //                 return;
        //             }
        //             // 收集所有的值
        //             cache.push(value);
        //         }
        //         return value;
        //     });
        //     cache = null; // 清空变量，便于垃圾回收机制回收
        // } else {
        //     data = params;
        // }
        var cmdStr = "curl --user admines:adminGSBes. -k -H 'Content-type:" + ContentType + "'";
        if (headData) {
            var headDataKeys = Object.keys(headData);
            if (headDataKeys.length > 0) {
                for (let index = 0; index < headDataKeys.length; index++) {
                    const indexKey = headDataKeys[index];
                    var headValue = headData[indexKey];
                    if (indexKey && headValue) {
                        cmdStr = cmdStr + " -H '" + indexKey + ":" + headValue + "'";
                    }
                }
            }
        }
        cmdStr = cmdStr + " -d '" + data + "' " + url;
        console.log(cmdStr, "：cmdStr.................");
        return cmdStr;
    }

    /**
     * 返回20位业务订单号
     * @param {*} prefix 业务前缀
     */
    async getBusUid(prefix) {
        prefix = (prefix || "");
        if (prefix) {
            prefix = prefix.toUpperCase();
        }
        var prefixlength = prefix.length;
        var subLen = 8 - prefixlength;
        var uidStr = "";
        if (subLen > 0) {
            uidStr = await this.getUidInfo(subLen, 60);
        }
        var timStr = moment().format("YYYYMMDDHHmm");
        return prefix + timStr + uidStr;
    }

    /**
     * 返回指定长度的字符串
     * @param {*} len 返回长度
     * @param {*} radix 参与计算的长度，最大为62
     */
    async getUidInfo(len, radix) {
        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
        var uuid = [], i;
        radix = radix || chars.length;
        if (len) {
            for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
        } else {
            var r;
            uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
            uuid[14] = '4';
            for (i = 0; i < 36; i++) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                }
            }
        }
        return uuid.join('');
    }

    //--------------------------------------------------辅助方法end-----------------
}

module.exports = ExecClientNew;
