var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ChannelAPI extends APIBase {
   constructor() {
      super();
      this.channelS=system.getObject("service.common.channelSve")
   }
   async getChannels(hostname){
      let cacheManager = system.getObject("db.common.cacheManager");
      let channels=await cacheManager["ChannelCache"].cache(hostname)
      return channels;
   }
   async channelHandle(channelobj,path,data){
     let rtn=await  this.channelS.channelHandle(channelobj,path,data)
     return rtn;
   }
   classDesc() {
      return {
         groupName: "auth",
         groupDesc: "认证相关的包",
         name: "AccessAuthAPI",
         desc: "关于认证的类",
         exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
      };
   }
   methodDescs() {
      return [
    
      ];
   }
   exam() {
      return ``
   }
}
module.exports = ChannelAPI;
