const CtlBase = require("../../ctl.base");
var system = require("../../../system");

class PushlogCtl extends CtlBase {
  constructor() {
    super("qifutong", CtlBase.getServiceName(PushlogCtl));
  }
  // 获取 推送 log信息 
  async getPushFailLogList(pobj, qobj, req) {
    try {
      const rs = await this.service.getPushFailLogList(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async failLogrePush(pobj, qobj, req) {
    if (!pobj.id) {
      return system.getResult(null, "id  can not be empty，100290");
    }
    try {
      const rs = await this.service.failLogrePush(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getGatewayPushFailLogList(pobj, qobj, req) {
    try {
      const rs = await this.service.getGatewayPushFailLogList(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async reGatewayPush(pobj, qobj, req) {
    try {
      const rs = await this.service.reGatewayPush(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

}
module.exports = PushlogCtl;
