const CtlBase = require("../../ctl.base");
var system = require("../../../system");
class StatisticsCtl extends CtlBase {
  constructor() {
    super("qifutong", CtlBase.getServiceName(StatisticsCtl));
  }
  // 获取 渠道信息 
  async getAllChannels(pobj, qobj, req) {
    try {
      const rs = await this.service.getAllChannels(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }
  // 获取 渠道信息 
  async getAllService(pobj, qobj, req) {
    try {
      const rs = await this.service.getAllService(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async submitService(pobj, qobj, req) {
    try {
      const rs = await this.service.submitService(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async editService(pobj, qobj, req) {
    try {
      const rs = await this.service.editService(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getAllProductType(pobj, qobj, req) {
    try {
      const rs = await this.service.getAllProductType(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async submitProductType(pobj, qobj, req) {
    try {
      const rs = await this.service.submitProductType(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async editProductType(pobj, qobj, req) {
    try {
      const rs = await this.service.editProductType(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 获取 产品信息 
  async getAllProducts(pobj, qobj, req) {
    try {
      const rs = await this.service.getAllProducts(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 获取 pathName
  async getPathName(pobj, qobj, req) {
    try {
      const rs = await this.service.getPathName(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }
  // 需求渠道分析
  async getStatisticsByUappId(pobj, qobj, req) {
    try {
      const rs = await this.service.getStatisticsByUappId(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 订单渠道分析
  async getOrderStatisticsByUappId(pobj, qobj, req) {
    try {
      const rs = await this.service.getOrderStatisticsByUappId(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 需求漏斗图
  async getNeedFunnelStatistics(pobj, qobj, req) {
    try {
      const rs = await this.service.getNeedFunnelStatistics(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 需求产品分析
  async getStatisticsByProduct(pobj, qobj, req) {
    try {
      const rs = await this.service.getStatisticsByProduct(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 订单产品分析
  async getOrderStatisticsByProduct(pobj, qobj, req) {
    try {
      const rs = await this.service.getOrderStatisticsByProduct(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 需求地区分析
  async getStatisticsByArea(pobj, qobj, req) {
    try {
      const rs = await this.service.getStatisticsByArea(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getNeedComparison(pobj, qobj, req) {
    try {
      const rs = await this.service.getNeedComparison(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }
  async getOrdersComparison(pobj, qobj, req) {
    try {
      const rs = await this.service.getOrdersComparison(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getStatisticsList(pobj, qobj, req) {
    try {
      const rs = await this.service.getStatisticsList(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async importTxNeeds(pobj, qobj, req) {
    try {
      const rs = await this.service.importTxNeeds(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getNeedProductType(pobj, qobj, req) {
    try {
      const rs = await this.service.getNeedProductType(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  // 渠道订单统计
  async getChannelOrderStatistics(pobj, qobj, req) {
    try {
      const rs = await this.service.getChannelOrderStatistics(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

  async getChannelNeedStatistics(pobj, qobj, req) {
    try {
      const rs = await this.service.getChannelNeedStatistics(pobj);
      return system.getResult(rs);
    } catch (err) {
      return system.getResult(null, err.message)
    }
  }

}
module.exports = StatisticsCtl;
