const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppCache extends CacheBase{
  constructor(){
    super();
    this.prefix="g_centerappkey:";
    this.appDao=system.getObject("db.common.appDao");
  }
  isdebug(){
   return settings.env=="dev";
 }
  desc(){
    return "缓存本地应用对象";
 }
 prefix(){
    return "g_applocal_cm:"
 }
 async buildCacheVal(cachekey,inputkey, val, ex, ...items) {
   const configValue=await this.appDao.findOne({appkey:inputkey});
   if (configValue) {
     return JSON.stringify(configValue);
   }
   return null;
 }
}
module.exports=AppCache;