const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class LoopDistributionUserCache extends CacheBase {
  constructor() {
    super();
    this.userDao = system.getObject("db.auth.userDao");
    this.channelDao = system.getObject("db.common.channelDao");
  }
  isdebug() {
    return settings.env == "dev";
  }
  desc() {
    return "缓存阿里订单轮循环分配的业务员信息";
  }
  prefix() {
    return "g_loopDistributionUserInfo_cm:"
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    if (val) {
        return val;
    }
    return null;
  }
}
module.exports = LoopDistributionUserCache;