var system = require("../../../../system");
const sha235 = require("sha256");
var settings = require("../../../../../config/settings");
class TxHandler {
  constructor() {
    this.icUrl = settings.icUrl() + "/web/bizchance";
    this.userService = system.getObject("service.auth.userSve");
    this.msgService = system.getObject("service.msg.msgSve")
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  /**
   * 需要调用生成者接口，把数据丢入队列
   * 组装生产者需要的数据结构
   * @param {*} datajson 
   */
  //新商机处理
  async addChance(datajson) {
    console.log("put in queue", datajson);
    try {
      var cachestr = sha235(JSON.stringify(datajson));
      var cacheInfo = await this.cacheManager["TxCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      }
      else {
        //获取分配的业务员信息
        var ConsultTypeName = datajson.actionBody.ConsultTypeName.split("/")[2];
        var salesmanInfo = await this.userService.getBizUserForBizChance(datajson.actionBody.ContactsMobile, datajson.actionBody.ServicerName, ConsultTypeName, datajson.actionBody.RegionName);
        console.log("salesman   " + salesmanInfo);
        var rc = system.getObject("util.execClient");
        var requrl = this.icUrl + "/bizoptCtl/insertInfo";
        var params = {
          "businessMode": datajson.actionBody.NeedNum,
          "servicerName": datajson.actionBody.ServicerName,
          "serviceCode": datajson.actionBody.RegionId,
          "serviceName": datajson.actionBody.RegionName,
          "contactsName": datajson.actionBody.ContactsName,
          "contactsPhone": datajson.actionBody.ContactsMobile,
          "businessType": datajson.actionBody.ConsultType,
          "businessName": datajson.actionBody.ConsultTypeName,
          "currentStatus" : "beforeSubmission",
          "channelSource": "tencentCloud",
          "sourceNumber":"tx"
        }
        if (datajson.actionBody.Notes && datajson.actionBody.Notes != 'undefined') {
          params.memoInfo = datajson.actionBody.Notes;
        }
        if (datajson.actionBody.CompanyName && datajson.actionBody.CompanyName != 'undefined') {
          params.companyName = datajson.actionBody.CompanyName;
        }
        if (datajson.actionBody.UserName && datajson.actionBody.UserName != 'undefined') {
          params.UserName = datajson.actionBody.UserName;
        }
        if (salesmanInfo && salesmanInfo != 'undefined') {
          params.salesmanOpcode = salesmanInfo.opath;
          params.salesmanId = salesmanInfo.userId;
          params.clerkName = salesmanInfo.userName;
          params.clerkPhone = salesmanInfo.mobile;
          params.servicerCode = salesmanInfo.compId
        }
        var rtn = await rc.execPost3({ "d": params }, requrl);
        var j = JSON.parse(rtn.stdout);
        console.log(JSON.stringify(j), "RRRRRRRRRRRRRRR");
        if (j.status == 1) {
          await this.cacheManager["TxCache"].cache(cachestr, JSON.stringify({cachestr: cachestr}), 180);//插入redis缓存
          //给业务员发信息
          var msg = {
            "title": "你有新的商机，请尽快处理",
            "content": "商机编号" + params.businessMode + ",商机类型是" + params.businessName + ",服务地区是" + params.serviceName,
            "sender": "管理员",
            "sender_id":0,
            "msgType": "single",
            "target": { "id": params.salesmanId, "name": params.clerkName },
          }
          if (params.businessType == "/qcfw/icp/" || params.businessType == "/qcfw/edi/" || params.businessType == "/qcfw/icpannals/" || params.businessType == "/qcfw/ediannals/") {
            msg.app_key = "5ae2da88-0ced-4b7a-98ea-60d5e1ff7e2e";
            msg.jump_address = "allDispose"
          }
          else {
            msg.app_key = "42d814c1-4daa-4643-88b2-f5dd3ec853f3";
            msg.jump_address = "myChance"
          }
          await this.msgService.create(msg);
        }
        return j;
      }
    }
    catch (error) {
      console.log("TTTTTTTTTTTTTT");
      console.log(error);
      return system.getResultError(error);
    }

  }

  //退回商机处理
  async needClose(datajson) {
    console.log("put in queue" + JSON.stringify(datajson) + "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD");
    try {
      var cachestr = sha235(JSON.stringify(datajson));
      var cacheInfo = await this.cacheManager["TxCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      }
      else {
        var rc = system.getObject("util.execClient");
        var requrl = this.icUrl + "/schemeCtl/updateStatusByDemandCode";
        var params = {
          "d": {
            "businessMode": datajson.actionBody.NeedNum,
            "schemeNumber": datajson.actionBody.SolutionNum,
            "currentStatus": "isReject",
            "statusReason": datajson.actionBody.RefusalContent
          }
        }
        var rtn = await rc.execPost3(params, requrl);
        var j = JSON.parse(rtn.stdout);
        if (j.status == 0) {
          await this.cacheManager["TxCache"].cache(cachestr, JSON.stringify({cachestr: cachestr}), 180);//插入缓存

          //给业务员发信息
          var selUrl = this.icUrl + "/schemeCtl/findInfoByDemandCode";
          var selpar = {
            "d": {
              "businessMode": datajson.actionBody.NeedNum
            }
          }
          rtn = await rc.execPost3(selpar, selUrl);
          var jj = JSON.parse(rtn.stdout);
          console.log("jj------------------------------" + rtn.stdout);
          if (jj.status == 0 && jj.data){
            var msg = {
              "title": "你有退回的商机，请尽快处理",
              "content": "商机编号" + jj.data.businessMode + ",商机类型是" + jj.data.businessName,
              "sender": "管理员",
              "sender_id":0,
              "msgType": "single",
              "target": { "id": jj.data.clerkId, "name": jj.data.clerkName },
            }
            if (jj.data.businessType == "ICP" || jj.data.businessType == "EDI" || jj.data.businessType == "ICPANNUALREPORT" || jj.data.businessType == "EDIANNUALREPORT") {
              msg.app_key = "5ae2da88-0ced-4b7a-98ea-60d5e1ff7e2e";
              msg.jump_address = "allDispose"
            }
            else {
              msg.app_key = "42d814c1-4daa-4643-88b2-f5dd3ec853f3";
              msg.jump_address = "myChance"
            }
            var msgInfo = await this.msgService.create(msg);
            console.log("msgInfo -----------------------------" + msgInfo);
          }

          return {
            "status": 1,    //1代表成功，否则失败
            "msg": "成功",
            "data": "",
            "requestId": ""
          }
        }
        else {
          return j;
        }
      }
    }
    catch (error) {
      return system.getResultError(error);
    }

  }

  //交付单处理
  async orderSubmit(datajson) {
    console.log("put in queue-----------------------------------------------------------------------------------------------------", datajson);
    try {
      var cachestr = sha235(JSON.stringify(datajson));
      var cacheInfo = await this.cacheManager["TxCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      }
      else {
        var rc = system.getObject("util.execClient");
        var requrl = this.icUrl + "/deliverybillCtl/findInfoByDeliverCode";
        var delInfo = await rc.execPost3({ "d": { "deliverNumber": datajson.actionBody.orderNum } }, requrl);
        console.log("jdelInfo---------------------------------------------" + delInfo.stdout);
        var jdelInfo = JSON.parse(delInfo.stdout);
        if (jdelInfo.status == 0) {
          return {
            "status": 1,    //1代表成功，否则失败
            "msg": "数据已存在",
            "data": "",
            "requestId": ""
          }
        }
        else {
          //获取分配的业务员信息
          var ConsultTypeName = "";
          console.log("productTypeName-----------------------------" + datajson.actionBody.productTypeName);
          if (datajson.actionBody.productTypeName && datajson.actionBody.productTypeName != 'undefined') {
            ConsultTypeName = datajson.actionBody.productTypeName.split("/")[2];
          }
          console.log("ConsultTypeName-----------------------------" + ConsultTypeName);
          var salesmanInfo = await this.userService.getBizUserForDelivery(datajson.actionBody.orderSnapshot.contactsPhone, datajson.actionBody.servicerName, ConsultTypeName, datajson.actionBody.txPriceCode, datajson.actionBody.regionName);
          requrl = this.icUrl + "/deliverybillCtl/insertInfo";
          var bizurl = this.icUrl + "/bizoptCtl/updateStatusByDemandCode";
          var params = {
            "channelSource": "tencentCloud",
            "sourceNumber":"tx",
            "deliverNumber": datajson.actionBody.orderNum,
            "servicerName": datajson.actionBody.servicerName,
            "serviceCode": datajson.actionBody.regionId,
            "serviceName": datajson.actionBody.regionName,
            "businessType": datajson.actionBody.productType,
            "businessName": ConsultTypeName,
            "skuCode": datajson.actionBody.txPriceCode,
            "txOrderNum": datajson.actionBody.txOrderNum,
            "deliverStatus": "received",
            "baseInfo": {
              "txOrderNum": datajson.actionBody.txOrderNum,
              "isAdviser": "已分配",//是否分配顾问
              "contactsName": datajson.actionBody.orderSnapshot.contactsName,
              "contactsPhone": datajson.actionBody.orderSnapshot.contactsPhone,
              "payStatus": "待交付"
            },
            "companyInfo": {},
            "registeredInfo": {},
            "positionInfo": {},
            "regInfo": {},
            "express_info": {}
          }
          if (salesmanInfo && salesmanInfo != 'undefined') {
            params.clerkOpcode = salesmanInfo.opath;
            params.clerkId = salesmanInfo.userId;
            params.clerkName = salesmanInfo.userName;
            //params.clerkPhone = salesmanInfo.mobile;
            params.costPrice = salesmanInfo.cost;
            params.servicerCode = salesmanInfo.compId;
            params.baseInfo.clerkName = salesmanInfo.userName;
            params.baseInfo.clerkPhone = salesmanInfo.mobile
          }
          if (!params.servicerCode || params.servicerCode == 'undefined') {
            if (datajson.actionBody.orderSnapshot.servicerCode && datajson.actionBody.orderSnapshot.servicerCode != 'undefined') {
              params.servicerCode = datajson.actionBody.orderSnapshot.servicerCode;//fuwushang id
            }
          }
          if (datajson.actionBody.orderSnapshot.needNum && datajson.actionBody.orderSnapshot.needNum != 'undefined') {
            params.businessMode = datajson.actionBody.orderSnapshot.needNum;//商机编号
          }
          if (datajson.actionBody.realTotalCost && datajson.actionBody.realTotalCost != 'undefined') {
            params.sellingPrice = datajson.actionBody.realTotalCost;//价格
          }
          // if (datajson.actionBody.orderSnapshot.channelSource && datajson.actionBody.orderSnapshot.channelSource != 'undefined') {
          //   params.channelSource = datajson.actionBody.orderSnapshot.channelSource;//渠道名称
          // }
          // if (datajson.actionBody.orderSnapshot.channelNumber && datajson.actionBody.orderSnapshot.channelNumber != 'undefined') {
          //   params.channelNumber = datajson.actionBody.orderSnapshot.channelNumber;//渠道编码
          // }
          if (datajson.actionBody.orderSnapshot.hasOwnProperty("isWhether")) {
            if (datajson.actionBody.orderSnapshot.isWhether === true || datajson.actionBody.orderSnapshot.isWhether === "yes") {
              params.baseInfo.isWhether = "yes";//是否刻章
            }
            else {
              params.baseInfo.isWhether = "no";//是否刻章
            }
          }
          if (datajson.actionBody.orderSnapshot.hasOwnProperty("financial")) {
            if (datajson.actionBody.orderSnapshot.financial === true || datajson.actionBody.orderSnapshot.financial === "yes") {
              params.baseInfo.financial = "yes";
            }
            else {
              params.baseInfo.financial = "no";
            }
          }
          if (datajson.actionBody.orderSnapshot.officialSeal && datajson.actionBody.orderSnapshot.officialSeal != 'undefined') {
            params.baseInfo.officialSeal = datajson.actionBody.orderSnapshot.officialSeal;//公章扫描件
          }
          if (datajson.actionBody.orderSnapshot.businessLicense && datajson.actionBody.orderSnapshot.businessLicense != 'undefined') {
            params.baseInfo.businessLicense = datajson.actionBody.orderSnapshot.businessLicense;//营业执照扫描件
          }
          if (datajson.actionBody.orderSnapshot.taxpayerName && datajson.actionBody.orderSnapshot.taxpayerName != 'undefined') {
            params.baseInfo.taxpayerName = datajson.actionBody.orderSnapshot.taxpayerName;//纳税人类型名称
          }
          else if (datajson.actionBody.orderSnapshot.taxpayerType && datajson.actionBody.orderSnapshot.taxpayerType != 'undefined') {
            params.baseInfo.taxpayerName = datajson.actionBody.orderSnapshot.taxpayerType;//纳税人类型名称
          }
          if (datajson.actionBody.orderSnapshot.buyDuration && datajson.actionBody.orderSnapshot.buyDuration != 'undefined') {
            params.baseInfo.buyDuration = datajson.actionBody.orderSnapshot.buyDuration;//购买时长
          }
          else if (datajson.actionBody.orderSnapshot.timeSpan && datajson.actionBody.orderSnapshot.timeSpan != 'undefined') {
            params.baseInfo.buyDuration = datajson.actionBody.orderSnapshot.timeSpan + "年";//购买时长
          }
          if (datajson.actionBody.orderSnapshot.buyTime && datajson.actionBody.orderSnapshot.buyTime != 'undefined') {
            params.baseInfo.buyTime = datajson.actionBody.orderSnapshot.buyTime;//购买时间
          }
          if (datajson.actionBody.orderSnapshot.isRenew && datajson.actionBody.orderSnapshot.isRenew != 'undefined') {
            params.baseInfo.isRenew = datajson.actionBody.orderSnapshot.isRenew;//是否自动续费
          }
          if (datajson.actionBody.orderSnapshot.memoInfo && datajson.actionBody.orderSnapshot.memoInfo != 'undefined') {
            params.baseInfo.memoInfo = datajson.actionBody.orderSnapshot.memoInfo;
          }
          else if (datajson.actionBody.orderSnapshot.businessContent && datajson.actionBody.orderSnapshot.businessContent != 'undefined') {
            params.baseInfo.memoInfo = datajson.actionBody.orderSnapshot.businessContent;
          }
          if (datajson.actionBody.orderSnapshot.whetherType && datajson.actionBody.orderSnapshot.whetherType != 'undefined') {
            params.baseInfo.whetherType = datajson.actionBody.orderSnapshot.whetherType;//刻章类型
          }
          if (datajson.actionBody.orderSnapshot.hasOwnProperty("annualReport")) {//年报信息
            params.baseInfo.annualReport = datajson.actionBody.orderSnapshot.annualReport;
          }
          else{
            if (datajson.actionBody.orderSnapshot.annual_report && datajson.actionBody.orderSnapshot.annual_report != 'undefined') {
              params.baseInfo.annualReport = true;//shifouxuyaonianbao
            }
            else {
              params.baseInfo.annualReport = false;
            }
          }
          if (datajson.actionBody.orderSnapshot.hasOwnProperty("addressType")) {//注册地址类型
            if (datajson.actionBody.orderSnapshot.addressType === true || datajson.actionBody.orderSnapshot.addressType === "practical") {
              params.baseInfo.addressType = "practical";
            }
            else {
              params.baseInfo.addressType = "virtual";
            }
          }
          if (datajson.actionBody.orderSnapshot.subjectType && datajson.actionBody.orderSnapshot.subjectType != 'undefined') {
            params.baseInfo.subjectType = datajson.actionBody.orderSnapshot.subjectType;//代理记账主体类型
          }
          if (datajson.actionBody.orderSnapshot.companyName && datajson.actionBody.orderSnapshot.companyName != 'undefined') {
            params.baseInfo.companyName = datajson.actionBody.orderSnapshot.companyName;//公司名称
            params.companyInfo.companyName = datajson.actionBody.orderSnapshot.companyName;
          }
          else if (datajson.actionBody.orderSnapshot.company && datajson.actionBody.orderSnapshot.company != 'undefined') {
            params.baseInfo.companyName = datajson.actionBody.orderSnapshot.company;//公司名称
            params.companyInfo.companyName = datajson.actionBody.orderSnapshot.company;
          }
          if (datajson.actionBody.orderSnapshot.companyProperties && datajson.actionBody.orderSnapshot.companyProperties != 'undefined') {
            params.companyInfo.companyPropertiesName = datajson.actionBody.orderSnapshot.companyProperties;//公司性质名称
          }
          else if (datajson.actionBody.orderSnapshot.companyType && datajson.actionBody.orderSnapshot.companyType != 'undefined') {
            params.companyInfo.companyPropertiesName = datajson.actionBody.orderSnapshot.companyType;//公司性质名称
          }
          else if (datajson.actionBody.orderSnapshot.registeredName && datajson.actionBody.orderSnapshot.registeredName != 'undefined') {
            params.companyInfo.companyPropertiesName = datajson.actionBody.orderSnapshot.registeredName;//公司性质名称
          }
          if (datajson.actionBody.orderSnapshot.fullAddress && datajson.actionBody.orderSnapshot.fullAddress != 'undefined') {
            params.companyInfo.fullAddress = datajson.actionBody.orderSnapshot.fullAddress;//详细地址
          }
          else if (datajson.actionBody.orderSnapshot.residenceAddress && datajson.actionBody.orderSnapshot.residenceAddress != 'undefined') {
            params.companyInfo.fullAddress = datajson.actionBody.orderSnapshot.residenceAddress;//详细地址
          }
          if (datajson.actionBody.orderSnapshot.virtualPrice && datajson.actionBody.orderSnapshot.virtualPrice != 'undefined') {
            params.companyInfo.virtualPrice = datajson.actionBody.orderSnapshot.virtualPrice;//虚拟地址价格
            params.baseInfo.virtualPrice = datajson.actionBody.orderSnapshot.virtualPrice;//虚拟地址价格
          }
          if (datajson.actionBody.orderSnapshot.residenceAddress && datajson.actionBody.orderSnapshot.residenceAddress != 'undefined') {
            params.companyInfo.residenceAddress = datajson.actionBody.orderSnapshot.residenceAddress;//zhusuo
          }
          if (datajson.actionBody.orderSnapshot.engagedIndustry && datajson.actionBody.orderSnapshot.engagedIndustry != 'undefined') {
            params.companyInfo.engagedIndName = datajson.actionBody.orderSnapshot.engagedIndustry;//从事行业名称
          }
          if (datajson.actionBody.orderSnapshot.businessScope && datajson.actionBody.orderSnapshot.businessScope != 'undefined') {
            params.companyInfo.businessScope = datajson.actionBody.orderSnapshot.businessScope;//经营范围
          }
          if (datajson.actionBody.orderSnapshot.operatingPeriod && datajson.actionBody.orderSnapshot.operatingPeriod != 'undefined') {
            params.companyInfo.operatingPeriod = datajson.actionBody.orderSnapshot.operatingPeriod;//经营期限
          }
          if (datajson.actionBody.orderSnapshot.businessTerm && datajson.actionBody.orderSnapshot.businessTerm != 'undefined') {
            params.companyInfo.businessTerm = datajson.actionBody.orderSnapshot.businessTerm;//经营期限
          }
          if (datajson.actionBody.orderSnapshot.registeredCapital && datajson.actionBody.orderSnapshot.registeredCapital != 'undefined') {
            params.companyInfo.registeredCapital = datajson.actionBody.orderSnapshot.registeredCapital;//注册资本
          }
          if (datajson.actionBody.orderSnapshot.creditCode && datajson.actionBody.orderSnapshot.creditCode != 'undefined') {
            params.companyInfo.creditCode = datajson.actionBody.orderSnapshot.creditCode;//统一社会信用代码
          }
          if (datajson.actionBody.orderSnapshot.establishedTime && datajson.actionBody.orderSnapshot.establishedTime != 'undefined') {
            params.companyInfo.establishedTime = datajson.actionBody.orderSnapshot.establishedTime;//成立时间
          }
          if (datajson.actionBody.orderSnapshot.shareholderName && datajson.actionBody.orderSnapshot.shareholderName != 'undefined') {
            params.companyInfo.shareholderName = datajson.actionBody.orderSnapshot.shareholderName;//法人代表
          }

          var rtn = await rc.execPost3({ "d": params }, requrl);
          var j = JSON.parse(rtn.stdout);
          console.log("j---------------------------------" + rtn.stdout);
          var stau = {
            "businessMode": params.businessMode,
            "currentStatus": "isFinished",
            "statusReason": ""
          }
          rtn = await rc.execPost3({ "d": stau }, bizurl);//更新商机状态为已完成
          var j1 = JSON.parse(rtn.stdout);
          console.log("j1---------------------------------" + rtn.stdout);
          if (j.status == 0 && j1.status == 0) {
            await this.cacheManager["TxCache"].cache(cachestr, JSON.stringify({cachestr: cachestr}), 180);
            //给业务员发信息
            var msg = {
              "title": "你有新的交付单，请尽快处理",
              "content": "交付单编号" + params.deliverNumber + ",产品类型是" + params.businessName + ",服务地区是" + params.serviceName,
              "sender": "管理员",
              "sender_id":0,
              "msgType": "single",
              "target": { "id": params.clerkId, "name": params.clerkName },
            }
            if (params.businessType == "/qcfw/icp/" || params.businessType == "/qcfw/edi/" || params.businessType == "/qcfw/icpannals/" || params.businessType == "/qcfw/ediannals/") {
              msg.app_key = "5ae2da88-0ced-4b7a-98ea-60d5e1ff7e2e";
              msg.jump_address = "deliveryAll"
            }
            else {
              msg.app_key = "42d814c1-4daa-4643-88b2-f5dd3ec853f3";
              msg.jump_address = "myDeliver"
            }
            await this.msgService.create(msg);
            return {
              "status": 1,    //1代表成功，否则失败
              "msg": "",
              "data": "",
              "requestId": ""
            }
          }
          else {
            return j;
          }
        }
      }
    }
    catch (error) {
      console.log("error-------------------------------------" + error);
      return system.getResultError(error);
    }
  }

  //关闭交付单处理
  async orderClose(datajson) {
    console.log("put in queue", datajson);
    try {
      var cachestr = sha235(JSON.stringify(datajson));
      var cacheInfo = await this.cacheManager["TxCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      }
      else {
        var rc = system.getObject("util.execClient");
        var requrl = this.icUrl + "/deliverybillCtl/updateStatusByDeliverCode";
        var params = {
          "d": {
            "deliverNumber": datajson.actionBody.orderNum,
            "deliverStatus": "closed",
            "statusReason": datajson.actionBody.refusalContent
          }
        }
        var rtn = await rc.execPost3(params, requrl);
        var j = JSON.parse(rtn.stdout);
        if (j.status == 0) {
          await this.cacheManager["TxCache"].cache(cachestr, JSON.stringify({cachestr: cachestr}), 180);//插入缓存

          //给业务员发信息
          var selUrl = this.icUrl + "/deliverybillCtl/findInfoByDeliverCode";
          var selpar = {
            "d":{
              "deliverNumber":datajson.actionBody.orderNum
            }
          }
          rtn = await rc.execPost3(selpar, selUrl);
          var jj = JSON.parse(rtn.stdout);
          console.log("jj-------------------------" + rtn.stdout);
          if (jj.status ==0  && jj.data){
            var msg = {
              "title": "你有关闭的交付单，请尽快处理",
              "content": "交付单编号" + jj.data.delivery_code + ",产品类型是" + jj.data.product_name,
              "sender": "管理员",
              "sender_id":0,
              "msgType": "single",
              "target": { "id": jj.data.salesman_id, "name": jj.data.salesman_name },
            }
            if (jj.data.product_code == "ICP" || jj.data.product_code == "EDI" || jj.data.product_code == "ICPANNUALREPORT" || jj.data.product_code == "EDIANNUALREPORT") {
              msg.app_key = "5ae2da88-0ced-4b7a-98ea-60d5e1ff7e2e";
              msg.jump_address = "deliveryAll"
            }
            else {
              msg.app_key = "42d814c1-4daa-4643-88b2-f5dd3ec853f3";
              msg.jump_address = "myDeliver"
            }
            await this.msgService.create(msg);
          }
         
          return {
            "status": 1,    //1代表成功，否则失败
            "msg": "",
            "data": "",
            "requestId": ""
          }
        }
        else {
          return j;
        }
      }
    }
    catch (error) {
      return system.getResultError(error);
    }

  }
}

module.exports = new TxHandler();

// (async ()=>{
//   var task = new TxHandler();
//   var d = await task.userService.getBizUserForDelivery("16512345678","公司宝","公司注册","sv_business_registration_category_limited1","北京");
//   console.log("ddddddddddddd");
//   console.log(JSON.stringify(d));
//   console.log("dddddddddddddd");
// })()

