const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class TreeArchService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(TreeArchService));
  }
  async getRegions () {
    let rs = await this.dao.model.findAll({ attributes: ['regionJSON'] })
    return JSON.parse(rs[0].regionJSON)
  }
  async getSysArchJSON () {
    let rs = await this.dao.model.findAll({ attributes: ['sysArchJSON'] })
    return JSON.parse(rs[0].sysArchJSON)
  }
  async saveSysArchJSON (sysArchJSON, p) {
    var self = this
    return this.db.transaction(async function (t) {
      let rs = await self.dao.model.findAll({ transaction: t })
      let upobj = rs[0]
      upobj.sysArchJSON = JSON.stringify(sysArchJSON)
      upobj.save({ transaction: t })
      //节点删除，判断是否有子，如果有不能删除
      if (!p.olddata) {//表示当卡删除节点动作
        let at = await self.db.models.article.findOne({ where: { archpath: p.curdata.orgpath }, transaction: t })
        // if (at) {

        // }
      }
      if (p.olddata && p.olddata.orgpath != p.curdata.orgpath) {//如果路径编码修改了
        let ats = await self.db.models.article.findAll({ where: { archpath: p.olddata.orgpath }, transaction: t })
        for (let at of ats) {
          at.archpath = p.curdata.orgpath
          await at.save({ transaction: t })
        }
      }
      return sysArchJSON
    })
  }
  async saveRegions (regionJson) {
    let rs = await this.dao.model.findAll()
    let upobj = rs[0]
    upobj.regionJSON = JSON.stringify(regionJson)
    upobj.save()
    return regionJson
  }
  async getProductcats () {
    let rs = await this.dao.model.findAll({ attributes: ['productcatJSON'] })
    return JSON.parse(rs[0].productcatJSON)
  }
  async saveProductcats (productcatJson) {
    let rs = await this.dao.model.findAll()
    let upobj = rs[0]
    upobj.productcatJSON = JSON.stringify(productcatJson)
    upobj.save()
    return productcatJson
  }
  // async itetree(jsontree, level, results) {
  //   jsontree.forEach(item => {
  //     if (item.level < level) {
  //       let cloneobj = { ...item }
  //       if (results) {
  //         results.push(cloneobj)
  //       }
  //       if (item.children) {
  //         cloneobj.children = []
  //         itetree(item.children, level, cloneobj.children)
  //       }
  //     } else {
  //       if (results) {
  //         results.push(cloneobj)
  //       }
  //     }
  //   })
  // }
  findNodeByCode (jsontree, code, results) {
    jsontree.forEach(item => {
      if (item.code == code) {
        if (item.children) {
          item.children.forEach(c => {
            let tmp = { ...c }
            tmp.loading = false
            if (tmp.children) {
              tmp.children = []
            }
            results.push(tmp)
          })
          //this.findNodeByCode(item.children, code, results)
        }
      } else {
        if (item.children) {
          this.findNodeByCode(item.children, code, results)
        }
      }
    })
  }
  async getTreeArchByCode (archName, code) {
    let results = []
    let rs = await this.dao.model.findAll({ attributes: [archName] })
    let jsontree = JSON.parse(rs[0][archName])
    this.findNodeByCode(jsontree, code, results)
    console.log(results)
    return results;
  }
  /**
   * 按照字段和及级别读取树部分节点
   * @param {*} archName 
   * @param {*} level 
   */
  // async getTreeArchs(archName, level) {
  //   let results = []
  //   let rs = await this.dao.model.findAll({ attributes: [archName] })
  //   let jsontree = JSON.parse(rs[0].[archName])
  //   await this.itetree(jsontree, level, results)
  //   console.log(results)
  //   return results;
  // }
}
module.exports = TreeArchService;
// (async ()=>{
//   const fs=require("fs")
//   let treeS=new TreeArchService();
//   let s= fs.readFileSync("./a.json")
//   await treeS.dao.model.create({id:1,regionJSON:s})
//   console.log("insert ok.....")
//  //  let x=await u.cregister("jiangong")
//  //  console.log(x)
//  // let x=await u.cunregister("jiangong")
//  //  console.log(x)
//   // let t=await u.cmakejwt()
//   // console.log(t)
//   //let ux=await u.cjsonregister(AppService.newRouteUrl("test-service2"),{name:"test-service2",hosts:["ttest1.com"]})
//   //let ux=await u.cjsonregister(AppService.newServiceUrl(),{name:"test-service3",url:"http://zhichan.gongsibao.com"})
//   //let ux=await u.cdel(AppService.routeUrl("test-service2"))
//   //let ux=await u.cdel(AppService.serviceUrl("test-service2"))
//   //  let ux=await u.create({name:"test4-service",backend:"zhichan-service",domainName:"domain.com"})
//   //   console.log(ux);
//   // let delrtn=await u.delete({id:2,name:"test4-service"})
//   // console.log(delrtn);
// })()